/*
 * Decompiled with CFR 0.152.
 */
package com.ftdichip.ftd2xx;

import com.ftdichip.ftd2xx.DataBits;
import com.ftdichip.ftd2xx.Device;
import com.ftdichip.ftd2xx.FTD2xxException;
import com.ftdichip.ftd2xx.FlowControl;
import com.ftdichip.ftd2xx.Parity;
import com.ftdichip.ftd2xx.StopBits;
import javax.util.Localizer;

public class Port {
    private Device device;

    Port(Device device) {
        this.device = device;
    }

    public void reset() throws FTD2xxException {
        Port.reset(this.device.getHandle());
    }

    private static native void reset(long var0) throws FTD2xxException;

    public void setBaudRate(long l) throws FTD2xxException {
        if (l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(Localizer.getLocalizedMessage(Port.class, (String)"error.invalidBaudRate", (Object[])new Object[]{l}));
        }
        Port.setBaudRate(this.device.getHandle(), l);
    }

    private static native void setBaudRate(long var0, long var2) throws FTD2xxException;

    public void setDivisor(int n) throws FTD2xxException {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException(Localizer.getLocalizedMessage(Port.class, (String)"error.invalidDivisor", (Object[])new Object[]{n}));
        }
        Port.setDivisor(this.device.getHandle(), n);
    }

    private static native void setDivisor(long var0, int var2) throws FTD2xxException;

    public void setDataCharacteristics(DataBits dataBits, StopBits stopBits, Parity parity) throws FTD2xxException {
        Port.setDataCharacteristics(this.device.getHandle(), dataBits.value, stopBits.value, parity.value);
    }

    private static native void setDataCharacteristics(long var0, int var2, int var3, int var4) throws FTD2xxException;

    public void setFlowControl(FlowControl flowControl) throws FTD2xxException {
        if (flowControl == FlowControl.XON_XOFF) {
            throw new IllegalArgumentException(Localizer.getLocalizedMessage(Port.class, (String)"error.setFlowControl1.invalidUsage"));
        }
        Port.setFlowControl(this.device.getHandle(), flowControl.value, '\u0000', '\u0000');
    }

    public void setFlowControl(FlowControl flowControl, char c, char c2) throws FTD2xxException {
        if (flowControl != FlowControl.XON_XOFF) {
            throw new IllegalArgumentException(Localizer.getLocalizedMessage(Port.class, (String)"error.setFlowControl2.invalidUsage"));
        }
        Port.setFlowControl(this.device.getHandle(), flowControl.value, c, c2);
    }

    private static native void setFlowControl(long var0, int var2, char var3, char var4) throws FTD2xxException;

    public void setDTR(boolean bl) throws FTD2xxException {
        Port.setDTR(this.device.getHandle(), bl);
    }

    private static native void setDTR(long var0, boolean var2) throws FTD2xxException;

    public void setRTS(boolean bl) throws FTD2xxException {
        Port.setRTS(this.device.getHandle(), bl);
    }

    private static native void setRTS(long var0, boolean var2) throws FTD2xxException;

    public void setBreakOn(boolean bl) throws FTD2xxException {
        Port.setBreakOn(this.device.getHandle(), bl);
    }

    private static native void setBreakOn(long var0, boolean var2) throws FTD2xxException;
}

