/*
 * Decompiled with CFR 0.152.
 */
package com.ftdichip.ftd2xx;

import com.ftdichip.ftd2xx.Device;
import com.ftdichip.ftd2xx.DeviceDescriptor;
import com.ftdichip.ftd2xx.DeviceType;
import com.ftdichip.ftd2xx.FTD2xxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.util.Localizer;
import javax.util.property.Property;
import javax.util.property.PropertyPersistenceManager;

public final class Service {
    private static final Logger logger = Logger.getLogger(Service.class.getName());
    @Property(defaultValue=" ")
    private static String configFile;
    @Property(key="com.ftdichip.ftd2xx.Device.writeTimeout", defaultValue="300")
    private static int writeTimeout;
    @Property(key="com.ftdichip.ftd2xx.Device.readTimeout", defaultValue="300")
    private static int readTimeout;
    @Property(key="com.ftdichip.ftd2xx.Device.latencyTimer", defaultValue="-1")
    private static int latencyTimer;
    @Property(key="com.ftdichip.ftd2xx.Device.resetPipeRetryCount", defaultValue="-1")
    private static int resetPipeRetryCount;
    @Property(key="com.ftdichip.ftd2xx.Device.usbReceiveBufferSize", defaultValue="-1")
    private static int usbReceiveBufferSize;
    @Property(key="com.ftdichip.ftd2xx.Device.usbTransmitBufferSize", defaultValue="-1")
    private static int usbTransmitBufferSize;

    private static void loadProperties() throws FileNotFoundException, IOException {
        URL uRL = null;
        try {
            uRL = new URL(configFile);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = new File(configFile).toURI().toURL();
        }
        logger.config(Localizer.getLocalizedMessage(Service.class, (String)"loadProperties.logger.config", (Object[])new Object[]{uRL}));
        InputStream inputStream = uRL.openStream();
        Service.loadProperties(inputStream);
        inputStream.close();
    }

    private static void loadProperties(InputStream inputStream) throws IOException {
        System.getProperties().load(inputStream);
    }

    private static void initializeProperties() {
        try {
            PropertyPersistenceManager.initializeFromSystemProperties((Object[])new Object[]{Service.class});
        }
        catch (Exception exception) {
            throw new RuntimeException(Localizer.getLocalizedMessage(Service.class, (String)"initializeProperties.error"), exception);
        }
    }

    static void configureDevice(Device device) throws FTD2xxException {
        device.reset();
        device.purgeReceiveBuffer();
        device.purgeTransmitBuffer();
        if (writeTimeout >= 0) {
            logger.config(String.format("writeTimeout: %d", writeTimeout));
            device.setWriteTimeout(writeTimeout);
        }
        if (readTimeout >= 0) {
            logger.config(String.format("readTimeout: %d", readTimeout));
            device.setReadTimeout(readTimeout);
        }
        if (latencyTimer >= 0) {
            logger.config(String.format("latencyTimer: %d", latencyTimer));
            device.setLatencyTimer(latencyTimer);
        }
        if (usbReceiveBufferSize >= 0 && usbTransmitBufferSize >= 0) {
            logger.config(String.format("usbReceiveBufferSize: %d", usbReceiveBufferSize));
            logger.config(String.format("usbTransmitBufferSize: %d", usbTransmitBufferSize));
            device.setUSBParameters(usbReceiveBufferSize, usbTransmitBufferSize);
        }
        if (resetPipeRetryCount >= 0) {
            logger.config(String.format("resetPipeRetryCount: %d", resetPipeRetryCount));
            device.setResetPipeRetryCount(resetPipeRetryCount);
        }
    }

    private Service() {
    }

    public static native Device[] listDevices() throws FTD2xxException;

    public static Device[] listDevicesByType(DeviceType deviceType) throws FTD2xxException {
        ArrayList<Device> arrayList = new ArrayList<Device>();
        for (Device device : Service.listDevices()) {
            if (device.getType() != deviceType) continue;
            arrayList.add(device);
        }
        return arrayList.toArray(new Device[arrayList.size()]);
    }

    public static Device[] listDevicesByDescription(String string) throws FTD2xxException {
        ArrayList<Device> arrayList = new ArrayList<Device>();
        for (Device device : Service.listDevices()) {
            try {
                DeviceDescriptor deviceDescriptor = device.getDeviceDescriptor();
                if (!deviceDescriptor.getProductDescription().equals(string)) continue;
                arrayList.add(device);
            }
            catch (FTD2xxException fTD2xxException) {
                logger.log(Level.SEVERE, "Failed to access device descriptor.", fTD2xxException);
            }
        }
        return arrayList.toArray(new Device[arrayList.size()]);
    }

    public static Device[] listDevicesBySerialNumber(String string) throws FTD2xxException {
        ArrayList<Device> arrayList = new ArrayList<Device>();
        for (Device device : Service.listDevices()) {
            if (device.getDeviceDescriptor().getSerialNumber() != string) continue;
            arrayList.add(device);
        }
        return arrayList.toArray(new Device[arrayList.size()]);
    }

    public void startInputTask(Device device) throws FTD2xxException {
        Service.startInputTask(device.getHandle());
    }

    private static native void startInputTask(long var0) throws FTD2xxException;

    public void stopInputTask(Device device) throws FTD2xxException {
        Service.stopInputTask(device.getHandle());
    }

    private static native void stopInputTask(long var0) throws FTD2xxException;

    static {
        try {
            System.loadLibrary("ftd2xxj");
            if (configFile != null) {
                Service.loadProperties();
            }
            Service.initializeProperties();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, Localizer.getLocalizedMessage(Service.class, (String)"initProperties.error"), iOException);
        }
    }
}

