/*
 * Decompiled with CFR 0.152.
 */
package com.ftdichip.ftd2xx.ui;

import com.ftdichip.ftd2xx.Device;
import com.ftdichip.ftd2xx.FTD2xxException;
import com.ftdichip.ftd2xx.ui.DeviceInformationViewer;
import com.ftdichip.ftd2xx.ui.deviceDescriptor.DeviceDescriptorViewer;
import com.ftdichip.ftd2xx.ui.deviceTree.DevicesTreePanel;
import com.ftdichip.ftd2xx.ui.eeprom.EEPROMViewer;
import com.ftdichip.ftd2xx.ui.event.SelectionChangeListener;
import com.ftdichip.ftd2xx.ui.event.SelectionChangedEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class Main
extends JFrame
implements SelectionChangeListener {
    private static final Logger logger = Logger.getLogger(Main.class.getName());
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JSplitPane jSplitPane = null;
    private JTabbedPane jTabbedPane = null;
    private DeviceDescriptorViewer deviceDescriptorViewer;
    private EEPROMViewer eepromViewer;

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            DevicesTreePanel devicesTreePanel = new DevicesTreePanel();
            devicesTreePanel.addSelectionChangeListener(this);
            this.jSplitPane.setLeftComponent(devicesTreePanel);
            this.jSplitPane.setRightComponent(this.getJTabbedPane());
            this.jSplitPane.setDividerSize(5);
            this.jSplitPane.setDividerLocation(200);
        }
        return this.jSplitPane;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.setTabPlacement(3);
            this.jTabbedPane.addTab("Descriptor", null, this.getDeviceDescriptorViewer(), "Device descriptor information");
            this.jTabbedPane.addTab("EEPROM", null, this.getEEPROMViewer(), "EEPROM User Area contents");
        }
        return this.jTabbedPane;
    }

    private DeviceDescriptorViewer getDeviceDescriptorViewer() {
        if (this.deviceDescriptorViewer == null) {
            this.deviceDescriptorViewer = new DeviceDescriptorViewer();
        }
        return this.deviceDescriptorViewer;
    }

    private EEPROMViewer getEEPROMViewer() {
        if (this.eepromViewer == null) {
            this.eepromViewer = new EEPROMViewer();
        }
        return this.eepromViewer;
    }

    public static void main(String[] stringArray) {
        Main main = new Main();
        main.setVisible(true);
    }

    public Main() {
        this.initialize();
        this.centerToScreen();
    }

    private void centerToScreen() {
        Dimension dimension = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds().getSize();
        Rectangle rectangle = this.getBounds();
        int n = dimension.width / 2;
        int n2 = dimension.height / 2;
        int n3 = rectangle.width / 2;
        int n4 = rectangle.height / 2;
        rectangle.x = n - n3;
        rectangle.y = n2 - n4;
        this.setBounds(rectangle);
    }

    private void initialize() {
        this.setDefaultCloseOperation(3);
        this.setSize(489, 372);
        this.setContentPane(this.getJContentPane());
        this.setTitle("FTD2xx Device Explorer");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJSplitPane(), "Center");
        }
        return this.jContentPane;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.updateDeviceInformationViewers(selectionChangedEvent.getAffectedDevice());
    }

    private void updateDeviceInformationViewers(Device device) {
        int n = 0;
        Component[] componentArray = this.getJTabbedPane().getComponents();
        try {
            if (device != null) {
                device.open();
            }
            for (Component component : componentArray) {
                try {
                    if (device != null) {
                        ((DeviceInformationViewer)((Object)component)).update(device);
                    } else {
                        ((DeviceInformationViewer)((Object)component)).clear();
                    }
                }
                catch (FTD2xxException fTD2xxException) {
                    logger.log(Level.SEVERE, String.format("Failed to update \"%s\" viewer.", this.getJTabbedPane().getTitleAt(n)), fTD2xxException);
                    ((DeviceInformationViewer)((Object)component)).clear();
                }
                ++n;
            }
            if (device != null) {
                device.close();
            }
        }
        catch (FTD2xxException fTD2xxException) {
            logger.log(Level.SEVERE, "Failed to access device.", fTD2xxException);
        }
    }
}

