/*
 * Decompiled with CFR 0.152.
 */
package com.ftdichip.ftd2xx.ui.deviceDescriptor;

import com.ftdichip.ftd2xx.DeviceDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

class DeviceDescriptorTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(DeviceDescriptorTableModel.class.getName());
    private static final int PROPERTY_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private static final String[] columns = new String[]{"Property", "Value"};
    private Map<Method, Object> map = new TreeMap<Method, Object>(new PropertyMethodComparator());
    private Map.Entry<Method, Object>[] entries = new Map.Entry[0];

    DeviceDescriptorTableModel() {
    }

    public int getColumnCount() {
        return columns.length;
    }

    public String getColumnName(int n) {
        return columns[n];
    }

    public int getRowCount() {
        int n = 0;
        if (this.map != null) {
            n = this.map.size();
        }
        return n;
    }

    public Object getValueAt(int n, int n2) {
        Map.Entry<Method, Object> entry = this.entries[n];
        Object object = null;
        if (n2 == 0) {
            object = this.getPropertyMethodName(entry.getKey());
        }
        if (n2 == 1) {
            object = entry.getValue();
        }
        return object;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void update(DeviceDescriptor deviceDescriptor) {
        this.map.clear();
        this.initMap(deviceDescriptor);
        this.fireTableDataChanged();
    }

    private void initMap(DeviceDescriptor deviceDescriptor) {
        for (Method method : deviceDescriptor.getClass().getMethods()) {
            try {
                if (!this.isPropertyMethod(method)) continue;
                this.map.put(method, this.getValue(deviceDescriptor, method));
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Failed to retrieve value from method " + method.getName(), exception);
            }
        }
        this.entries = this.map.entrySet().toArray(this.entries);
    }

    String getPropertyMethodName(Method method) {
        String string = method.getName();
        String string2 = null;
        string2 = string.startsWith("get") ? string.substring("get".length()) : string.substring("is".length());
        return string2;
    }

    private boolean isPropertyMethod(Method method) {
        String string = method.getName();
        return string.startsWith("is") || string.startsWith("get") && !string.equals("getClass") && method.getParameterTypes().length == 0;
    }

    private Object getValue(DeviceDescriptor deviceDescriptor, Method method) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return method.invoke((Object)deviceDescriptor, new Object[0]);
    }

    public void clear() {
        this.map.clear();
        this.fireTableDataChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertyMethodComparator
    implements Comparator<Method> {
        private PropertyMethodComparator() {
        }

        @Override
        public int compare(Method method, Method method2) {
            String string = DeviceDescriptorTableModel.this.getPropertyMethodName(method);
            String string2 = DeviceDescriptorTableModel.this.getPropertyMethodName(method2);
            return string.compareTo(string2);
        }
    }
}

