/*
 * Decompiled with CFR 0.152.
 */
package com.ftdichip.ftd2xx.ui.deviceTree;

import com.ftdichip.ftd2xx.Device;
import com.ftdichip.ftd2xx.FTD2xxException;
import com.ftdichip.ftd2xx.ui.deviceTree.DeviceRenderer;
import com.ftdichip.ftd2xx.ui.deviceTree.DevicesTreeModel;
import com.ftdichip.ftd2xx.ui.event.SelectionChangeListener;
import com.ftdichip.ftd2xx.ui.event.SelectionChangeSupport;
import com.ftdichip.ftd2xx.ui.event.SelectionChangedEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.util.Localizer;

public class DevicesTreePanel
extends JPanel
implements TreeSelectionListener,
SelectionChangeSupport {
    private static final Logger logger = Logger.getLogger(DevicesTreePanel.class.getName());
    private List<SelectionChangeListener> listeners = new ArrayList<SelectionChangeListener>();
    private static final long serialVersionUID = 1L;
    private JScrollPane jScrollPane = null;
    private JTree jTree = null;
    private JButton refreshButton = null;
    private JToolBar jToolBar = null;

    public DevicesTreePanel() {
        this.initialize();
        this.refreshLater();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(300, 347);
        this.add((Component)this.getJScrollPane(), "Center");
        this.add((Component)this.getJToolBar(), "North");
    }

    void refreshLater() {
        new Timer(this.getClass().getSimpleName() + " - refreshLater Timer").schedule(new TimerTask(){

            public void run() {
                try {
                    logger.fine("Refresh device list.");
                    DevicesTreePanel.this.refresh();
                    logger.fine("Finished refreshing device list.");
                }
                catch (Throwable throwable) {
                    logger.log(Level.SEVERE, "Failed to refresh device list.", throwable);
                    DevicesTreePanel.this.getRefreshButton().setEnabled(false);
                    String string = Localizer.getLocalizedMessage(DevicesTreePanel.class, (String)"internal.error.title");
                    String string2 = Localizer.getLocalizedMessage(DevicesTreePanel.class, (String)"internal.error.message");
                    DevicesTreePanel.this.showError(string, string2, throwable);
                }
            }
        }, 100L);
    }

    void refresh() {
        try {
            this.jTree.clearSelection();
            ((DevicesTreeModel)this.jTree.getModel()).refresh();
            this.jTree.setSelectionRow(0);
        }
        catch (FTD2xxException fTD2xxException) {
            String string = "Failed to refresh device tree.";
            logger.log(Level.SEVERE, string, fTD2xxException);
            this.showError("FTStatus", string, fTD2xxException);
        }
    }

    private void showError(String string, String string2, Throwable throwable) {
        Throwable throwable2 = throwable;
        if (throwable != null) {
            while (throwable2.getCause() != null) {
                throwable2 = throwable2.getCause();
            }
        }
        String string3 = null;
        string3 = throwable2 != null ? Localizer.getLocalizedMessage(DevicesTreePanel.class, (String)"showError.textWithCause", (Object[])new Object[]{string2, throwable2.getMessage()}) : Localizer.getLocalizedMessage(DevicesTreePanel.class, (String)"showError.textWithoutCause", (Object[])new Object[]{string2});
        JOptionPane.showMessageDialog(this, string3, string, 0);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTree());
        }
        return this.jScrollPane;
    }

    private JTree getJTree() {
        if (this.jTree == null) {
            this.jTree = new JTree();
            this.jTree.setModel(new DevicesTreeModel());
            this.jTree.setCellRenderer(new DeviceRenderer());
            this.jTree.setRootVisible(false);
            this.jTree.addTreeSelectionListener(this);
            this.jTree.getSelectionModel().setSelectionMode(1);
        }
        return this.jTree;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.fireSelectionChanged(treeSelectionEvent.getSource());
    }

    public void addSelectionChangeListener(SelectionChangeListener selectionChangeListener) {
        if (this.listeners.contains(selectionChangeListener)) {
            throw new IllegalArgumentException(Localizer.getLocalizedMessage(DevicesTreePanel.class, (String)"error.listenerExists"));
        }
        this.listeners.add(selectionChangeListener);
    }

    public void removeSelectionChangeListener(SelectionChangeListener selectionChangeListener) {
        if (!this.listeners.contains(selectionChangeListener)) {
            throw new IllegalArgumentException(Localizer.getLocalizedMessage(DevicesTreePanel.class, (String)"error.listenerNotExists"));
        }
        this.listeners.remove(selectionChangeListener);
    }

    private void fireSelectionChanged(Object object) {
        for (SelectionChangeListener selectionChangeListener : this.listeners) {
            selectionChangeListener.selectionChanged(new SelectionChangedEvent(object, this.getSelectedDevice()));
        }
    }

    private Device getSelectedDevice() {
        TreePath treePath = this.jTree.getSelectionPath();
        Device device = null;
        if (treePath != null && treePath.getPath().length > 0) {
            device = (Device)((DefaultMutableTreeNode)treePath.getPath()[1]).getUserObject();
        }
        return device;
    }

    private JButton getRefreshButton() {
        if (this.refreshButton == null) {
            this.refreshButton = new JButton();
            this.refreshButton.setFocusPainted(false);
            this.refreshButton.setMargin(new Insets(0, 0, 0, 0));
            this.refreshButton.setToolTipText("Refreshes the devices tree.");
            this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/refresh.gif")));
            this.refreshButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DevicesTreePanel.this.refreshLater();
                }
            });
        }
        return this.refreshButton;
    }

    private JToolBar getJToolBar() {
        if (this.jToolBar == null) {
            this.jToolBar = new JToolBar();
            this.jToolBar.setFloatable(false);
            this.jToolBar.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.jToolBar.setBorderPainted(false);
            this.jToolBar.setMargin(new Insets(4, 0, 0, 0));
            this.jToolBar.setPreferredSize(new Dimension(20, 30));
            this.jToolBar.add(this.getRefreshButton());
        }
        return this.jToolBar;
    }
}

