/*
 * Decompiled with CFR 0.152.
 */
package com.ftdichip.ftd2xx.ui.eeprom;

import com.ftdichip.ftd2xx.EEPROM;
import com.ftdichip.ftd2xx.FTD2xxException;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EEPROMTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final int NUM_DATA_COLUMNS = 8;
    private static final int NUM_COLUMNS = 9;
    private static final int NUM_BYTES_PER_COLUMN = 2;
    static final int ASCII_COLUMN_INDEX = 8;
    private static final String ASCII_COLUMN_TEXT = "ASCII";
    private byte[] data = new byte[0];
    private int userAreaSize;

    EEPROMTableModel() {
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        Class clazz = Long.class;
        if (n == 8) {
            clazz = String.class;
        }
        return clazz;
    }

    @Override
    public String getColumnName(int n) {
        String string = ASCII_COLUMN_TEXT;
        if (n != 8) {
            string = Integer.toHexString(n * 2).toUpperCase();
        }
        return string;
    }

    @Override
    public int getRowCount() {
        return this.data.length / 18 + 1;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        int n3 = this.calculateDataOffset(n, n2);
        if (n3 + 2 < this.data.length) {
            object = EEPROMTableModel.getValue(this.data, n3, 2);
        }
        if (n2 == 8) {
            object = this.getASCII(n);
        }
        return object;
    }

    private int calculateDataOffset(int n, int n2) {
        return n * 8 * 2 + n2;
    }

    private String getASCII(int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n2 = this.calculateDataOffset(n, 0); i - n2 < 15 && i < this.data.length; ++i) {
            if (Character.isLetterOrDigit((char)this.data[i])) {
                stringBuilder.append(this.data[i]);
                continue;
            }
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    private static long getValue(byte[] byArray, int n, int n2) {
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            l |= (long)((byArray[n] & 0xFF) << i);
        }
        return l;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void update(EEPROM eEPROM) throws FTD2xxException {
        this.userAreaSize = eEPROM.getUserAreaSize();
        this.data = new byte[this.userAreaSize];
        eEPROM.readUserArea(this.data);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.data = new byte[0];
        this.fireTableDataChanged();
    }
}

