/*
 * Decompiled with CFR 0.152.
 */
package com.ftdichip.ftd2xx.ui.eeprom;

import com.ftdichip.ftd2xx.Device;
import com.ftdichip.ftd2xx.FTD2xxException;
import com.ftdichip.ftd2xx.ui.DeviceInformationViewer;
import com.ftdichip.ftd2xx.ui.eeprom.EEPROMTableCellRenderer;
import com.ftdichip.ftd2xx.ui.eeprom.EEPROMTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class EEPROMViewer
extends JPanel
implements DeviceInformationViewer {
    private static final long serialVersionUID = 1L;
    private JScrollPane jScrollPane = null;
    private JTable dataTable = null;
    private EEPROMTableModel dataTableModel = new EEPROMTableModel();

    public EEPROMViewer() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJScrollPane(), "Center");
    }

    public void update(Device device) throws FTD2xxException {
        this.dataTableModel.update(device.getEEPROM());
    }

    public void clear() {
        this.dataTableModel.clear();
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getDataTable());
        }
        return this.jScrollPane;
    }

    JTable getDataTable() {
        if (this.dataTable == null) {
            this.dataTable = new JTable();
            this.dataTable.setAutoResizeMode(3);
            this.dataTable.setRowHeight(20);
            this.dataTable.setRowSelectionAllowed(true);
            this.dataTable.setCellSelectionEnabled(true);
            this.dataTable.setSelectionMode(0);
            this.dataTable.setModel(this.dataTableModel);
            this.dataTable.setDefaultRenderer(Long.class, new EEPROMTableCellRenderer());
            this.dataTable.getTableHeader().setReorderingAllowed(false);
            this.dataTableModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (tableModelEvent.getType() == 0) {
                        TableColumn tableColumn = EEPROMViewer.this.getDataTable().getColumnModel().getColumn(8);
                        tableColumn.setMinWidth(tableColumn.getPreferredWidth());
                    }
                }
            });
        }
        return this.dataTable;
    }
}

