/*
 * Decompiled with CFR 0.152.
 */
package com.ingenotech.lavalamp;

import com.ingenotech.lavalamp.BuildState;
import com.ingenotech.lavalamp.BuildStatus;
import com.ingenotech.lavalamp.LavaLampServer;
import com.ingenotech.lavalamp.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.DatagramPacket;
import java.net.Socket;
import java.util.Arrays;

public class ConnectionHandler {
    private static final String PING = "PING";
    private static final String QUIT = "QUIT";
    private static final String MUTE = "MUTE";
    private static final String BUILDNAME = "NAME";
    private static final String BUILDRESULT = "RESULT";
    private LavaLampServer controller;

    public ConnectionHandler(LavaLampServer controller) {
        this.controller = controller;
    }

    public String handleConnection(DatagramPacket packet) {
        Log.log("UDP connection from: " + packet.getAddress() + ":" + packet.getPort());
        String data = new String(packet.getData(), packet.getOffset(), packet.getLength());
        StringReader in = new StringReader(data);
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.handleConnection(in, out);
        out.flush();
        return sw.toString();
    }

    public void handleConnection(Socket socket) throws IOException {
        Log.log("TCP connection from: " + socket);
        InputStreamReader in = new InputStreamReader(socket.getInputStream());
        PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
        this.handleConnection(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnection(Reader in, PrintWriter out) {
        try {
            String cmd;
            String line;
            out.println(LavaLampServer.VERSION);
            String buildName = null;
            BuildStatus buildStatus = null;
            BufferedReader br = new BufferedReader(in);
            while ((line = br.readLine()) != null && !(cmd = line.trim().toUpperCase()).startsWith(QUIT)) {
                if (cmd.startsWith(PING)) {
                    out.println("PING " + line.substring(PING.length()));
                    continue;
                }
                if (cmd.startsWith(BUILDNAME)) {
                    buildName = line.substring(BUILDNAME.length()).trim();
                    if (buildName.length() >= 1) continue;
                    buildName = null;
                    out.println("NAME requires a build name");
                    continue;
                }
                if (cmd.startsWith(BUILDRESULT)) {
                    String result = cmd.substring(BUILDRESULT.length()).trim();
                    try {
                        buildStatus = BuildStatus.valueOf(result);
                    }
                    catch (IllegalArgumentException iax) {
                        out.println("RESULT expects one of the following values:" + Arrays.asList(BuildStatus.values()));
                    }
                    continue;
                }
                if (cmd.startsWith(MUTE)) {
                    boolean mute = Boolean.valueOf(cmd.substring(MUTE.length()).trim());
                    this.controller.setMute(mute);
                    out.println("MUTE " + mute);
                    continue;
                }
                if (cmd.length() <= 0) continue;
                out.println("Unrecognised command: " + cmd);
                out.println("Expecting one of: PING,QUIT,NAME,RESULT,MUTE");
            }
            if (buildName != null && buildStatus != null) {
                BuildState bs = new BuildState(buildName, buildStatus);
                this.controller.updateState(bs);
            }
        }
        catch (IOException iox) {
            Log.log("handleConnection", iox);
        }
        finally {
            Log.log("handleConnection done.");
        }
    }
}

