/*
 * Decompiled with CFR 0.152.
 */
package com.ingenotech.lavalamp;

import com.ingenotech.lavalamp.ConnectionHandler;
import com.ingenotech.lavalamp.LavaLampServer;
import com.ingenotech.lavalamp.Log;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;

public class UDPListener
extends Thread {
    private ConnectionHandler handler;
    private DatagramSocket server;
    private InetAddress multicastGroup;
    private volatile boolean run;

    public UDPListener(LavaLampServer controller, InetSocketAddress listenAddress, InetAddress multicastGroup) throws IOException {
        this.handler = new ConnectionHandler(controller);
        if (multicastGroup != null && multicastGroup.isMulticastAddress()) {
            MulticastSocket ms = new MulticastSocket(listenAddress);
            ms.joinGroup(multicastGroup);
            this.multicastGroup = multicastGroup;
            this.server = ms;
        } else {
            this.server = new DatagramSocket(listenAddress);
        }
        this.run = true;
    }

    public void close() {
        this.run = false;
        this.server.close();
    }

    @Override
    public void run() {
        Log.log("UDPListener started on: " + this.server.getLocalSocketAddress() + (this.multicastGroup != null ? " (multicast group:" + this.multicastGroup + ")" : ""));
        try {
            while (this.run) {
                byte[] reqBuf = new byte[500];
                DatagramPacket reqPacket = new DatagramPacket(reqBuf, reqBuf.length);
                this.server.receive(reqPacket);
                String response = this.handler.handleConnection(reqPacket);
                if (response.length() <= 0) continue;
                byte[] respBuf = response.getBytes();
                DatagramPacket respPacket = new DatagramPacket(respBuf, respBuf.length, reqPacket.getSocketAddress());
                this.server.send(respPacket);
            }
        }
        catch (IOException iox) {
            Log.log("UDPListener.run() socket exception:", iox);
        }
        Log.log("UDPListener exited.");
    }
}

