/*
 * Decompiled with CFR 0.152.
 */
package com.ingenotech.lavalamp.ftdi;

import com.ingenotech.lavalamp.ftdi.Beeper;
import com.ingenotech.lavalamp.ftdi.DeviceWriter;

public class Beeper1
extends Thread
implements Beeper {
    private DeviceWriter device;
    private long runFor = 6000L;
    private volatile boolean run = true;

    public Beeper1(DeviceWriter device) {
        this.device = device;
    }

    @Override
    public void setRunFor(long msDuration) {
        this.runFor = msDuration;
    }

    @Override
    public void cancel() {
        this.run = false;
        this.interrupt();
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        long delay = 100L;
        long minDelay = 30L;
        int delta = 3;
        long runFor2 = this.runFor >> 2;
        long runFor1 = this.runFor - runFor2;
        boolean beep = true;
        do {
            this.device.setBeep(beep);
            boolean bl = beep = !beep;
            if ((delay -= (long)delta) <= minDelay) {
                delay = minDelay;
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException ix) {
                // empty catch block
            }
        } while (this.run && System.currentTimeMillis() - start < runFor1);
        if (this.run) {
            this.device.setBeep(true);
            try {
                Thread.sleep(runFor2);
            }
            catch (InterruptedException ix) {
                // empty catch block
            }
        }
        this.device.setBeep(false);
    }
}

