/*
 * Decompiled with CFR 0.152.
 */
package javax.util.property;

import java.awt.Color;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import javax.util.property.BooleanPropertyValueConverter;
import javax.util.property.BytePropertyValueConverter;
import javax.util.property.CharacterPropertyValueConverter;
import javax.util.property.ClassPropertyValueConverter;
import javax.util.property.ColorPropertyValueConverter;
import javax.util.property.DoublePropertyValueConverter;
import javax.util.property.EnumPropertyValueConverter;
import javax.util.property.FilePropertyValueConverter;
import javax.util.property.FloatPropertyValueConverter;
import javax.util.property.IntegerPropertyValueConverter;
import javax.util.property.LongPropertyValueConverter;
import javax.util.property.PropertyValueConverter;
import javax.util.property.PropertyValueConverterProvider;
import javax.util.property.ShortPropertyValueConverter;
import javax.util.property.StringPropertyValueConverter;
import javax.util.property.URLPropertyValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertyValueConverterProvider
implements PropertyValueConverterProvider {
    private static final Class[] defaultTypes = new Class[]{String.class, Integer.TYPE, Boolean.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.class, Boolean.class, Long.class, Float.class, Double.class, Byte.class, Short.class, Character.class, Class.class, Color.class, URL.class, File.class};
    private static final PropertyValueConverter<?>[] defaultTypesConverters = new PropertyValueConverter[]{new StringPropertyValueConverter(), new IntegerPropertyValueConverter(), new BooleanPropertyValueConverter(), new LongPropertyValueConverter(), new FloatPropertyValueConverter(), new DoublePropertyValueConverter(), new BytePropertyValueConverter(), new ShortPropertyValueConverter(), new CharacterPropertyValueConverter(), new IntegerPropertyValueConverter(), new BooleanPropertyValueConverter(), new LongPropertyValueConverter(), new FloatPropertyValueConverter(), new DoublePropertyValueConverter(), new BytePropertyValueConverter(), new ShortPropertyValueConverter(), new CharacterPropertyValueConverter(), new ClassPropertyValueConverter(), new ColorPropertyValueConverter(), new URLPropertyValueConverter(), new FilePropertyValueConverter()};
    private static final HashMap<Class<?>, PropertyValueConverter<?>> supportedTypesMap = new HashMap(defaultTypes.length);

    static {
        int i = 0;
        while (i < defaultTypes.length) {
            supportedTypesMap.put(defaultTypes[i], defaultTypesConverters[i]);
            ++i;
        }
    }

    public <T> PropertyValueConverter<?> getConverterFor(Class<T> fieldType) {
        PropertyValueConverter<?> converter = supportedTypesMap.get(fieldType);
        converter = fieldType.isEnum() ? new EnumPropertyValueConverter(fieldType) : supportedTypesMap.get(fieldType);
        return converter;
    }
}

