/*
 * Decompiled with CFR 0.152.
 */
package javax.util.property;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.util.property.PropertyProvider;
import javax.util.property.PropertyProviderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesPropertyProvider
implements PropertyProvider {
    private Preferences preferences;

    public PreferencesPropertyProvider(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public String getProperty(String key) {
        return this.preferences.get(key, null);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.preferences.get(key, defaultValue);
    }

    @Override
    public void setProperty(String key, String value) {
        this.preferences.put(key, value);
    }

    @Override
    public void flush() throws PropertyProviderException {
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            throw new PropertyProviderException(e, PreferencesPropertyProvider.class, "error.flush", this.preferences.absolutePath());
        }
    }

    @Override
    public Set<String> keys() throws PropertyProviderException {
        LinkedHashSet<String> result = null;
        try {
            String[] keys = this.preferences.keys();
            result = new LinkedHashSet<String>(keys.length);
            String[] stringArray = keys;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String key = stringArray[n];
                result.add(key);
                ++n;
            }
        }
        catch (BackingStoreException e) {
            throw new PropertyProviderException(e, PreferencesPropertyProvider.class, "error.keys", this.preferences.absolutePath());
        }
        return result;
    }
}

