/*
 * Decompiled with CFR 0.152.
 */
package javax.util.property;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.util.property.DefaultPropertyValueConverterProvider;
import javax.util.property.MissingPropertyException;
import javax.util.property.PreferencesPropertyProvider;
import javax.util.property.PropertiesPropertyProvider;
import javax.util.property.Property;
import javax.util.property.PropertyException;
import javax.util.property.PropertyProvider;
import javax.util.property.PropertyProviderException;
import javax.util.property.PropertyValueConverter;
import javax.util.property.PropertyValueConverterProvider;
import javax.util.property.UnsupportedPropertyTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyPersistenceManager {
    private static final List<PropertyValueConverterProvider> providers = new ArrayList<PropertyValueConverterProvider>();

    static {
        PropertyPersistenceManager.addPropertyValueConverterProvider(new DefaultPropertyValueConverterProvider());
    }

    public static void addPropertyValueConverterProvider(PropertyValueConverterProvider provider) {
        if (providers.contains(provider)) {
            throw new IllegalArgumentException("Providers can not be added twice.");
        }
        providers.add(provider);
    }

    public static void initialize(PropertyProvider provider, Object ... targets) throws PropertyException, PropertyProviderException {
        Object[] objectArray = targets;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object target = objectArray[n];
            PropertyPersistenceManager.initialize(provider, target);
            ++n;
        }
    }

    public static void initialize(PropertyProvider provider, Object target) throws PropertyException, PropertyProviderException {
        for (Field field : PropertyPersistenceManager.listPropertyFields(target)) {
            Property p = field.getAnnotation(Property.class);
            String value = PropertyPersistenceManager.getPropertyValue(field, p, provider);
            PropertyPersistenceManager.setFieldValue(field, target, PropertyPersistenceManager.convertToTargetValue(field, value));
        }
    }

    public static void initializeFromInputStream(InputStream in, Object ... targets) throws PropertyException {
        Properties p = new Properties();
        try {
            p.load(in);
        }
        catch (IOException e) {
            throw new PropertyException(e, PropertyPersistenceManager.class, "initializeFromInputStream.IOException", new Object[0]);
        }
        PropertyPersistenceManager.initialize((PropertyProvider)new PropertiesPropertyProvider(p), targets);
    }

    public static void initializeFromPreferences(Preferences preferences, Object ... targets) throws PropertyException, PropertyProviderException {
        PropertyPersistenceManager.initialize((PropertyProvider)new PreferencesPropertyProvider(preferences), targets);
    }

    public static void initializeFromSystemProperties(Object ... targets) throws PropertyException {
        PropertyPersistenceManager.initialize((PropertyProvider)new PropertiesPropertyProvider(System.getProperties()), targets);
    }

    public static void initializeFromXMLProperties(InputStream in, Object ... targets) throws PropertyException {
        Properties p = new Properties();
        try {
            p.loadFromXML(in);
        }
        catch (IOException e) {
            throw new PropertyException(e, PropertyPersistenceManager.class, "initializeFromXMLProperties.IOException", new Object[0]);
        }
        PropertyPersistenceManager.initialize((PropertyProvider)new PropertiesPropertyProvider(p), targets);
    }

    public static void removePropertyValueConverterProvider(PropertyValueConverterProvider provider) {
        if (!providers.contains(provider)) {
            throw new IllegalArgumentException("Provider not found.");
        }
        providers.remove(provider);
    }

    private static Object convertToTargetValue(Field field, String value) throws PropertyException {
        Object result = null;
        Class<?> fieldType = field.getType();
        PropertyValueConverter<?> converter = null;
        converter = PropertyPersistenceManager.getConverterFor(fieldType);
        if (converter == null) {
            throw new UnsupportedPropertyTypeException(PropertyPersistenceManager.class, "convertToTargetValue.UnsupportedType", fieldType);
        }
        try {
            result = converter.parseString(value);
        }
        catch (Exception e) {
            throw new PropertyException(e, PropertyPersistenceManager.class, "convertToTargetValue.Exception", field.getType(), value);
        }
        return result;
    }

    private static PropertyValueConverter<?> getConverterFor(Class<?> fieldType) throws UnsupportedPropertyTypeException {
        PropertyValueConverter<?> converter = null;
        for (PropertyValueConverterProvider p : providers) {
            converter = p.getConverterFor(fieldType);
            if (converter != null) break;
        }
        if (converter == null) {
            throw new UnsupportedPropertyTypeException(PropertyPersistenceManager.class, "getConverterFor.UnsupportedType", fieldType);
        }
        return converter;
    }

    private static String getPropertyValue(Field field, Property p, PropertyProvider properties) throws PropertyException {
        String key = PropertyPersistenceManager.getPropertyKey(field, p);
        String value = properties.getProperty(key);
        if (value == null && (value = p.defaultValue()).length() == 0) {
            throw new MissingPropertyException(PropertyPersistenceManager.class, "getValue.MissingRequiredProperty", key);
        }
        return value;
    }

    public static void store(PropertyProvider properties, Object ... targets) throws PropertyException, PropertyProviderException {
        Object[] objectArray = targets;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object target = objectArray[n];
            PropertyPersistenceManager.store(properties, target);
            ++n;
        }
    }

    public static void store(PropertyProvider properties, Object target) throws PropertyException, PropertyProviderException {
        for (Field field : PropertyPersistenceManager.listPropertyFields(target)) {
            Property p = field.getAnnotation(Property.class);
            Object value = PropertyPersistenceManager.getFieldValue(field, target);
            if (value == null) {
                throw new PropertyException(PropertyPersistenceManager.class, "illegalValue.null", field.getName());
            }
            properties.setProperty(PropertyPersistenceManager.getPropertyKey(field, p), PropertyPersistenceManager.convertToPropertyValue(field, value));
        }
        properties.flush();
    }

    public static void storeToXMLProperties(PropertyProvider provider, OutputStream out, Object ... targets) throws PropertyException {
        PropertyPersistenceManager.store(provider, targets);
        Properties properties = new Properties();
        for (String key : provider.keys()) {
            properties.put(key, provider.getProperty(key));
        }
        try {
            properties.storeToXML(out, null);
            out.flush();
        }
        catch (IOException e) {
            throw new PropertyException(e, PropertyPersistenceManager.class, "storeToXMLProperties.ioException", new Object[0]);
        }
    }

    public static void storeToSystemProperties(Object ... targets) throws PropertyException {
        PropertyPersistenceManager.store((PropertyProvider)new PropertiesPropertyProvider(System.getProperties()), targets);
    }

    public static void storeToPreferences(Preferences preferences, Object ... targets) throws PropertyException {
        PropertyPersistenceManager.store((PropertyProvider)new PreferencesPropertyProvider(preferences), targets);
    }

    private static String convertToPropertyValue(Field field, Object value) throws PropertyException, UnsupportedPropertyTypeException {
        String result = null;
        Class<?> fieldType = field.getType();
        PropertyValueConverter<?> converter = null;
        converter = PropertyPersistenceManager.getConverterFor(fieldType);
        try {
            result = converter.toString(value);
        }
        catch (Exception e) {
            throw new PropertyException(e, PropertyPersistenceManager.class, "convertToPropertyValue.Exception", field.getType(), value);
        }
        return result;
    }

    private static List<Field> listPropertyFields(Object target) {
        LinkedList<Field> fields = new LinkedList<Field>();
        boolean isClassContext = target instanceof Class;
        Class<?> targetClass = isClassContext ? (Class<?>)target : target.getClass();
        Field[] fieldArray = targetClass.getDeclaredFields();
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            Field field = fieldArray[n];
            Property p = field.getAnnotation(Property.class);
            boolean isNonProcessableField = isClassContext ^ Modifier.isStatic(field.getModifiers());
            if (p != null && !isNonProcessableField) {
                fields.add(field);
            }
            ++n;
        }
        return fields;
    }

    private static void setFieldValue(Field field, Object target, Object value) throws PropertyException {
        try {
            boolean isAccessible = field.isAccessible();
            field.setAccessible(true);
            field.set(target, value);
            field.setAccessible(isAccessible);
        }
        catch (IllegalAccessException e) {
            throw new PropertyException(e, PropertyPersistenceManager.class, "initialize.IllegalAccessException", field.getName());
        }
    }

    private static Object getFieldValue(Field field, Object target) throws PropertyException {
        Object result = null;
        try {
            boolean isAccessible = field.isAccessible();
            field.setAccessible(true);
            result = field.get(target);
            field.setAccessible(isAccessible);
        }
        catch (IllegalAccessException e) {
            throw new PropertyException(e, PropertyPersistenceManager.class, "initialize.IllegalAccessException", field.getName());
        }
        return result;
    }

    private static String getPropertyKey(Field field, Property p) {
        String result = p.key();
        if (result.length() == 0) {
            result = String.format("%s.%s", field.getDeclaringClass().getName(), field.getName());
        }
        return result;
    }
}

