/*
 * Decompiled with CFR 0.152.
 */
package com.ingenotech.hudson;

import com.ingenotech.hudson.Connection;
import com.ingenotech.hudson.TCPConnection;
import com.ingenotech.hudson.UDPConnection;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class LavaLampInstallation
extends Notifier
implements Serializable {
    private static final long serialVersionUID = -1502300463467252323L;
    private static final Logger LOG = Logger.getLogger(LavaLampInstallation.class.getName());
    private static final String DEFAULT_ADDRESS = "localhost";
    private static final int DEFAULT_PORT = 1999;
    private static final String PROTOCOL_TCP = "TCP";
    private static final String PROTOCOL_UDP = "UDP";
    private final String name;
    private final String address;
    private final int port;
    private final String protocol;

    @DataBoundConstructor
    public LavaLampInstallation(String name, String address, int port, String protocol) {
        this.name = name;
        this.address = address;
        this.port = port;
        this.protocol = protocol;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append(" (");
        sb.append(this.getAddress());
        sb.append(":");
        sb.append(this.getProtocol());
        sb.append(":");
        sb.append(this.getPort());
        sb.append(")");
        return sb.toString();
    }

    public String getAddress() {
        return this.address;
    }

    private static InetAddress parseAddress(String value) throws Exception {
        InetAddress ia = InetAddress.getByName(value);
        return ia;
    }

    public InetAddress getInetAddress() {
        InetAddress ia = null;
        try {
            ia = LavaLampInstallation.parseAddress(this.address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ia;
    }

    public int getPort() {
        return this.port;
    }

    private static int parsePort(String value) throws Exception {
        int p = Integer.parseInt(value);
        if (p < 1 || p > 65535) {
            throw new IllegalArgumentException("Port must be in the range 1..65535");
        }
        return p;
    }

    public String getProtocol() {
        return LavaLampInstallation.parseProtocol(this.protocol);
    }

    private static String parseProtocol(String value) {
        String pc = PROTOCOL_UDP;
        if (value != null && value.trim().equalsIgnoreCase(PROTOCOL_TCP)) {
            pc = PROTOCOL_TCP;
        }
        return pc;
    }

    public Connection newConnection() {
        return LavaLampInstallation.newConnection(this.getInetAddress(), this.getPort(), this.getProtocol());
    }

    private static Connection newConnection(InetAddress addr, int port, String protocol) {
        LOG.fine("newConnection(" + protocol + ")");
        if (PROTOCOL_TCP.equalsIgnoreCase(protocol)) {
            return new TCPConnection(addr, port);
        }
        return new UDPConnection(addr, port);
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        DescriptorImpl descr = (DescriptorImpl)super.getDescriptor();
        return descr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private LavaLampInstallation[] installations = new LavaLampInstallation[0];

        public DescriptorImpl() {
            super(LavaLampInstallation.class);
            this.load();
        }

        public String toString() {
            return "DescriptorImpl@" + Integer.toHexString(System.identityHashCode((Object)this)) + "[" + Arrays.asList(this.installations) + "]";
        }

        public String getDefaultAddress() {
            return LavaLampInstallation.DEFAULT_ADDRESS;
        }

        public int getDefaultPort() {
            return 1999;
        }

        public LavaLampInstallation[] getInstallations() {
            return (LavaLampInstallation[])this.installations.clone();
        }

        public void setInstallations(LavaLampInstallation ... installations) {
            this.installations = (LavaLampInstallation[])installations.clone();
        }

        public String getDisplayName() {
            return "Lava Lamp Installations";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return false;
        }

        public LavaLampInstallation newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (LavaLampInstallation)super.newInstance(req, formData);
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.setInstallations(req.bindJSONToList(this.clazz, formData.get("tool")).toArray((LavaLampInstallation[])Array.newInstance(this.clazz, 0)));
            this.save();
            return super.configure(req, formData);
        }

        public FormValidation doCheckAddress(@QueryParameter String value) throws IOException, ServletException {
            try {
                LavaLampInstallation.parseAddress(value);
            }
            catch (Exception ex) {
                return FormValidation.error((String)"Unable to resolve server name");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPort(@QueryParameter String value) throws IOException, ServletException {
            try {
                LavaLampInstallation.parsePort(value);
            }
            catch (Exception ex) {
                return FormValidation.error((String)"LavaLamp server port must be an integer 1..65535");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProtocol(@QueryParameter String value) throws IOException, ServletException {
            try {
                LavaLampInstallation.parseProtocol(value);
            }
            catch (Exception ex) {
                return FormValidation.error((String)"LavaLamp server protocol must be [TCP,UDP]");
            }
            return FormValidation.ok();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public FormValidation doTestServerConnection(@QueryParameter String address, @QueryParameter String port, @QueryParameter String protocol) {
            Connection c = null;
            try {
                InetAddress s = LavaLampInstallation.parseAddress(address);
                int p = LavaLampInstallation.parsePort(port);
                String u = LavaLampInstallation.parseProtocol(protocol);
                if (s.isMulticastAddress() && !LavaLampInstallation.PROTOCOL_UDP.equalsIgnoreCase(u)) {
                    FormValidation formValidation = FormValidation.error((String)"Protocol must be UDP for Multicast server address");
                    return formValidation;
                }
                c = LavaLampInstallation.newConnection(s, p, u);
                c.open();
                boolean ok = c.ping();
                String ident = c.getServerIdent();
                if (ok) {
                    String msg = s.isMulticastAddress() ? "Connection to LavaLamp server:" + ident + " tested - check the LavaLampServer log output as no response is sent when using multicast." : "Connection to LavaLamp server:" + ident + " tested successfully.";
                    FormValidation formValidation = FormValidation.ok((String)msg);
                    return formValidation;
                }
                FormValidation formValidation = FormValidation.error((String)("Connected to LavaLamp server:" + ident + " but ping failed."));
                return formValidation;
            }
            catch (Exception ex) {
                FormValidation formValidation = FormValidation.error((String)("Failed to connect to LavaLamp server at: " + address + ":" + port));
                return formValidation;
            }
            finally {
                if (c != null) {
                    try {
                        c.close();
                    }
                    catch (IOException ix) {}
                }
            }
        }
    }
}

