/*
 * Decompiled with CFR 0.152.
 */
package com.ingenotech.hudson;

import com.ingenotech.hudson.Connection;
import com.ingenotech.hudson.LavaLampInstallation;
import com.ingenotech.hudson.LavaLampNotifier;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LavaLampNotifier
extends Notifier
implements Serializable {
    private static final long serialVersionUID = 3019486479572911590L;
    private static final Logger LOG = Logger.getLogger(LavaLampNotifier.class.getName());
    private final String name;
    private final Boolean changesOnly;

    @DataBoundConstructor
    public LavaLampNotifier(String name, Boolean changesOnly) {
        this.name = name;
        if (changesOnly == null) {
            changesOnly = false;
        }
        this.changesOnly = changesOnly;
    }

    public String getName() {
        return this.name;
    }

    public boolean getChangesOnly() {
        return this.changesOnly;
    }

    public LavaLampInstallation getLavaLamp() {
        LavaLampInstallation[] all;
        DescriptorImpl descr = this.getDescriptor();
        for (LavaLampInstallation i : all = descr.getInstallations()) {
            if (this.name == null || !this.name.equals(i.getName())) continue;
            return i;
        }
        if (all.length > 0) {
            return all[0];
        }
        return null;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        LavaLampInstallation ll = this.getLavaLamp();
        if (ll == null) {
            LOG.log(Level.SEVERE, "No LavaLamp server selected for: " + build.getFullDisplayName());
            return true;
        }
        Result result = build.getResult();
        Result prevResult = null;
        AbstractBuild prevBuild = (AbstractBuild)build.getPreviousBuild();
        if (prevBuild != null) {
            prevResult = prevBuild.getResult();
        }
        if (result == prevResult && this.changesOnly.booleanValue()) {
            LOG.fine("perform() - changesOnly set and result unchanged");
            return true;
        }
        Connection c = null;
        try {
            c = ll.newConnection();
            c.open();
            c.sendResult(build.getFullDisplayName(), result);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to connect to LavaLamp server", ex);
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (IOException ix) {}
            }
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }
}

