/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jenkins;

import com.zeroturnaround.liverebel.api.ApplicationInfo;
import com.zeroturnaround.liverebel.api.CommandCenter;
import com.zeroturnaround.liverebel.api.CommandCenterFactory;
import com.zeroturnaround.liverebel.api.ConnectException;
import com.zeroturnaround.liverebel.api.DuplicationException;
import com.zeroturnaround.liverebel.api.Error;
import com.zeroturnaround.liverebel.api.Forbidden;
import com.zeroturnaround.liverebel.api.ParseException;
import com.zeroturnaround.liverebel.api.UploadInfo;
import com.zeroturnaround.liverebel.api.diff.DiffResult;
import com.zeroturnaround.liverebel.api.diff.Level;
import com.zeroturnaround.liverebel.api.update.ConfigurableUpdate;
import com.zeroturnaround.liverebel.util.LiveApplicationUtil;
import com.zeroturnaround.liverebel.util.LiveRebelXml;
import hudson.FilePath;
import hudson.model.BuildListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveRebelProxy {
    private final CommandCenterFactory commandCenterFactory;
    private final BuildListener listener;
    CommandCenter commandCenter;
    private boolean useOfflineUpdateIfCompatibleWithWarnings;

    public LiveRebelProxy(CommandCenterFactory centerFactory, BuildListener listener) {
        this.commandCenterFactory = centerFactory;
        this.listener = listener;
    }

    public boolean perform(FilePath[] wars, List<String> deployableServers, boolean useOfflineUpdateIfCompatibleWithWarnings) throws IOException, InterruptedException {
        if (wars.length == 0) {
            this.listener.getLogger().println("Could not find any artifact to deploy. Please, specify it in job configuration.");
            return false;
        }
        this.useOfflineUpdateIfCompatibleWithWarnings = useOfflineUpdateIfCompatibleWithWarnings;
        if (!this.initCommandCenter()) {
            return false;
        }
        boolean result = true;
        this.listener.getLogger().println("Deploying artifacts.");
        for (FilePath warFile : wars) {
            try {
                this.listener.getLogger().printf("Processing artifact: %s\n", warFile);
                LiveRebelXml lrXml = this.getLiveRebelXml(warFile);
                ApplicationInfo applicationInfo = this.commandCenter.getApplication(lrXml.getApplicationId());
                this.uploadIfNeeded(applicationInfo, lrXml.getVersionId(), warFile);
                result = result && this.update(lrXml, applicationInfo, warFile, deployableServers);
                this.listener.getLogger().printf("SUCCESS. Artifact deployed: %s\n", warFile);
            }
            catch (IllegalArgumentException e) {
                this.listener.getLogger().println("ERROR! " + e.getMessage());
                result = false;
            }
            catch (Error e) {
                this.listener.getLogger().println("ERROR! Unexpected error received from server.");
                this.listener.getLogger().println();
                this.listener.getLogger().println("URL: " + e.getURL());
                this.listener.getLogger().println("Status code: " + e.getStatus());
                this.listener.getLogger().println("Message: " + e.getMessage());
                result = false;
            }
            catch (ParseException e) {
                this.listener.getLogger().println("ERROR! Unable to read server response.");
                this.listener.getLogger().println();
                this.listener.getLogger().println("Response: " + e.getResponse());
                this.listener.getLogger().println("Reason: " + e.getMessage());
                result = false;
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof ZipException) {
                    this.listener.getLogger().printf("ERROR! Unable to read artifact (%s). The file you trying to deploy is not an artifact or may be corrupted.\n", warFile);
                } else {
                    this.listener.getLogger().println("ERROR! Unexpected error occured:");
                    this.listener.getLogger().println();
                    e.printStackTrace(this.listener.getLogger());
                }
                result = false;
            }
            catch (Throwable t) {
                this.listener.getLogger().println("ERROR! Unexpected error occured:");
                this.listener.getLogger().println();
                t.printStackTrace(this.listener.getLogger());
                result = false;
            }
        }
        return result;
    }

    boolean initCommandCenter() {
        try {
            this.commandCenter = this.commandCenterFactory.newCommandCenter();
            return true;
        }
        catch (Forbidden e) {
            this.listener.getLogger().println("ERROR! Access denied. Please, navigate to Jenkins Configuration to specify LiveRebel Authentication Token.");
            return false;
        }
        catch (ConnectException e) {
            this.listener.getLogger().println("ERROR! Unable to connect to server.");
            this.listener.getLogger().println();
            this.listener.getLogger().println("URL: " + e.getURL());
            if (e.getURL().equals("https://")) {
                this.listener.getLogger().println("Please, navigate to Jenkins Configuration to specify running LiveRebel Url.");
            } else {
                this.listener.getLogger().println("Reason: " + e.getMessage());
            }
            return false;
        }
    }

    boolean isFirstRelease(ApplicationInfo applicationInfo) {
        return applicationInfo == null;
    }

    boolean update(LiveRebelXml lrXml, ApplicationInfo applicationInfo, FilePath warfile, List<String> deployableServers) throws IOException, InterruptedException {
        if (deployableServers.isEmpty()) {
            this.listener.getLogger().println("No servers specified in LiveRebel configuration.");
            return false;
        }
        this.listener.getLogger().println("Starting updating application on servers:");
        boolean result = true;
        if (this.isFirstRelease(applicationInfo)) {
            result = this.deploy(lrXml, warfile, deployableServers);
        } else {
            ArrayList<String> diff = new ArrayList<String>(deployableServers);
            diff.removeAll(applicationInfo.getActiveVersionPerServer().keySet());
            for (Map.Entry versionWithServer : applicationInfo.getActiveVersionPerServer().entrySet()) {
                if (diff.contains(versionWithServer.getKey())) continue;
                result = result && this.activate(lrXml, (String)versionWithServer.getKey(), (String)versionWithServer.getValue(), warfile);
            }
            if (!diff.isEmpty()) {
                this.deploy(lrXml, warfile, diff);
            }
        }
        return result;
    }

    boolean deploy(LiveRebelXml lrXml, FilePath warfile, List<String> serverIds) {
        this.listener.getLogger().printf("Deploying new application on the %s.\n", serverIds.toString());
        this.commandCenter.deploy(lrXml.getApplicationId(), lrXml.getVersionId(), null, serverIds);
        this.listener.getLogger().printf("SUCCESS: Application deployed to %s.\n", serverIds.toString());
        return true;
    }

    boolean activate(LiveRebelXml lrXml, String server, String activeVersion, FilePath warfile) throws IOException, InterruptedException {
        this.listener.getLogger().printf("Server: %s, active version on server: %s.\n", server, activeVersion);
        if (activeVersion.equals(lrXml.getVersionId())) {
            this.listener.getLogger().println("Current version is already running on server. No need to update.");
            return true;
        }
        DiffResult diffResult = this.getDifferences(lrXml, activeVersion);
        this.listener.getLogger().printf("Activating version %s on %s server.\n", lrXml.getVersionId(), server);
        ConfigurableUpdate update = this.commandCenter.update(lrXml.getApplicationId(), lrXml.getVersionId());
        if (diffResult.getMaxLevel() == Level.ERROR || diffResult.getMaxLevel() == Level.WARNING && this.useOfflineUpdateIfCompatibleWithWarnings) {
            update.enableOffline();
        }
        update.execute();
        this.listener.getLogger().printf("SUCCESS: Version %s activated on %s server.\n", lrXml.getVersionId(), server);
        return true;
    }

    DiffResult getDifferences(LiveRebelXml lrXml, String activeVersion) {
        DiffResult diffResult = this.commandCenter.compare(lrXml.getApplicationId(), activeVersion, lrXml.getVersionId(), false);
        diffResult.print(this.listener.getLogger());
        this.listener.getLogger().println();
        return diffResult;
    }

    void uploadIfNeeded(ApplicationInfo applicationInfo, String currentVersion, FilePath warFile) throws IOException, InterruptedException {
        if (applicationInfo != null && applicationInfo.getVersions().contains(currentVersion)) {
            this.listener.getLogger().println("Current version of application is already uploaded. Skipping upload.");
        } else {
            this.uploadArtifact(new File(warFile.getRemote()));
        }
    }

    boolean uploadArtifact(File artifact) throws IOException, InterruptedException {
        try {
            UploadInfo upload = this.commandCenter.upload(artifact);
            this.listener.getLogger().printf("SUCCESS: %s %s was uploaded.\n", upload.getApplicationId(), upload.getVersionId());
            return true;
        }
        catch (DuplicationException e) {
            this.listener.getLogger().println(e.getMessage());
            return false;
        }
    }

    LiveRebelXml getLiveRebelXml(FilePath warFile) throws IOException, InterruptedException {
        LiveRebelXml lrXml = LiveApplicationUtil.findLiveRebelXml((File)new File(warFile.getRemote()));
        this.listener.getLogger().printf("Found LiveRebel xml. Current application is: %s %s.\n", lrXml.getApplicationId(), lrXml.getVersionId());
        return lrXml;
    }
}

