/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jenkins;

import com.zeroturnaround.liverebel.api.ApplicationInfo;
import com.zeroturnaround.liverebel.api.CommandCenter;
import com.zeroturnaround.liverebel.api.CommandCenterFactory;
import com.zeroturnaround.liverebel.api.ConnectException;
import com.zeroturnaround.liverebel.api.DuplicationException;
import com.zeroturnaround.liverebel.api.Error;
import com.zeroturnaround.liverebel.api.Forbidden;
import com.zeroturnaround.liverebel.api.ParseException;
import com.zeroturnaround.liverebel.api.UploadInfo;
import com.zeroturnaround.liverebel.api.diff.DiffResult;
import com.zeroturnaround.liverebel.api.diff.Level;
import com.zeroturnaround.liverebel.api.update.ConfigurableUpdate;
import com.zeroturnaround.liverebel.util.LiveApplicationUtil;
import com.zeroturnaround.liverebel.util.LiveRebelXml;
import hudson.FilePath;
import hudson.model.BuildListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipException;
import org.apache.commons.lang.StringUtils;
import org.zeroturnaround.jenkins.LiveRebelDeployPublisher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveRebelProxy {
    public static final String ARTIFACT_DEPLOYED_AND_UPDATED = "SUCCESS. Artifact deployed and activated in all %s servers: %s\n";
    private final CommandCenterFactory commandCenterFactory;
    private final BuildListener listener;
    private CommandCenter commandCenter;
    private LiveRebelDeployPublisher.Strategy strategy;
    private boolean useFallbackIfCompatibleWithWarnings;

    public LiveRebelProxy(CommandCenterFactory centerFactory, BuildListener listener) {
        this.commandCenterFactory = centerFactory;
        this.listener = listener;
    }

    public boolean perform(FilePath[] wars, String contextPath, List<String> deployableServers, LiveRebelDeployPublisher.Strategy strategy, boolean useFallbackIfCompatibleWithWarnings, boolean uploadOnly) throws IOException, InterruptedException {
        if (wars.length == 0) {
            this.listener.getLogger().println("Could not find any artifact to deploy. Please, specify it in job configuration.");
            return false;
        }
        if (deployableServers.isEmpty()) {
            this.listener.getLogger().println("No servers specified in LiveRebel configuration.");
            return false;
        }
        this.strategy = strategy;
        this.useFallbackIfCompatibleWithWarnings = useFallbackIfCompatibleWithWarnings;
        if (!this.initCommandCenter()) {
            return false;
        }
        this.listener.getLogger().println("Deploying artifacts.");
        for (FilePath warFile : wars) {
            boolean result = false;
            try {
                this.listener.getLogger().printf("Processing artifact: %s\n", warFile);
                LiveRebelXml lrXml = this.getLiveRebelXml(warFile);
                ApplicationInfo applicationInfo = this.getCommandCenter().getApplication(lrXml.getApplicationId());
                this.uploadIfNeeded(applicationInfo, lrXml.getVersionId(), warFile);
                if (!uploadOnly) {
                    this.update(lrXml, applicationInfo, warFile, deployableServers, contextPath);
                    this.listener.getLogger().printf(ARTIFACT_DEPLOYED_AND_UPDATED, deployableServers, warFile);
                }
                result = true;
            }
            catch (IllegalArgumentException e) {
                this.listener.getLogger().println("ERROR!");
                e.printStackTrace(this.listener.getLogger());
            }
            catch (Error e) {
                this.listener.getLogger().println("ERROR! Unexpected error received from server.");
                this.listener.getLogger().println();
                this.listener.getLogger().println("URL: " + e.getURL());
                this.listener.getLogger().println("Status code: " + e.getStatus());
                this.listener.getLogger().println("Message: " + e.getMessage());
            }
            catch (ParseException e) {
                this.listener.getLogger().println("ERROR! Unable to read server response.");
                this.listener.getLogger().println();
                this.listener.getLogger().println("Response: " + e.getResponse());
                this.listener.getLogger().println("Reason: " + e.getMessage());
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof ZipException) {
                    this.listener.getLogger().printf("ERROR! Unable to read artifact (%s). The file you trying to deploy is not an artifact or may be corrupted.\n", warFile);
                } else {
                    this.listener.getLogger().println("ERROR! Unexpected error occured:");
                    this.listener.getLogger().println();
                    e.printStackTrace(this.listener.getLogger());
                }
            }
            catch (Throwable t) {
                this.listener.getLogger().println("ERROR! Unexpected error occured:");
                this.listener.getLogger().println();
                t.printStackTrace(this.listener.getLogger());
            }
            if (result) continue;
            return result;
        }
        return true;
    }

    boolean initCommandCenter() {
        try {
            this.commandCenter = this.commandCenterFactory.newCommandCenter();
            return true;
        }
        catch (Forbidden e) {
            this.listener.getLogger().println("ERROR! Access denied. Please, navigate to Jenkins Configuration to specify LiveRebel Authentication Token.");
            return false;
        }
        catch (ConnectException e) {
            this.listener.getLogger().println("ERROR! Unable to connect to server.");
            this.listener.getLogger().println();
            this.listener.getLogger().println("URL: " + e.getURL());
            if (e.getURL().equals("https://")) {
                this.listener.getLogger().println("Please, navigate to Jenkins Configuration to specify running LiveRebel Url.");
            } else {
                this.listener.getLogger().println("Reason: " + e.getMessage());
            }
            return false;
        }
    }

    boolean isFirstRelease(ApplicationInfo applicationInfo) {
        return applicationInfo == null;
    }

    void update(LiveRebelXml lrXml, ApplicationInfo applicationInfo, FilePath warFile, List<String> selectedServers, String contextPath) throws IOException, InterruptedException {
        this.listener.getLogger().println("Starting updating application on servers:");
        Set deployServers = this.getDeployServers(applicationInfo, selectedServers);
        if (!deployServers.isEmpty()) {
            this.deploy(lrXml, warFile, deployServers, contextPath);
        }
        if (deployServers.size() != selectedServers.size()) {
            HashSet<String> activateServers = new HashSet<String>(selectedServers);
            activateServers.removeAll(deployServers);
            Level diffLevel = this.getMaxDifferenceLevel(applicationInfo, lrXml, activateServers);
            this.activate(lrXml, warFile, activateServers, diffLevel);
        }
    }

    void deploy(LiveRebelXml lrXml, FilePath warfile, Set<String> serverIds, String contextPath) {
        this.listener.getLogger().printf("Deploying new application on %s.\n", serverIds);
        if (contextPath == null || contextPath.equals("")) {
            contextPath = null;
        }
        this.getCommandCenter().deploy(lrXml.getApplicationId(), lrXml.getVersionId(), contextPath, serverIds);
        this.listener.getLogger().printf("SUCCESS: Application deployed to %s.\n", serverIds);
    }

    void activate(LiveRebelXml lrXml, FilePath warfile, Set<String> serverIds, Level diffLevel) throws IOException, InterruptedException {
        ConfigurableUpdate update = this.getCommandCenter().update(lrXml.getApplicationId(), lrXml.getVersionId());
        if (diffLevel == Level.ERROR || diffLevel == Level.WARNING && this.useFallbackIfCompatibleWithWarnings) {
            if (this.strategy == LiveRebelDeployPublisher.Strategy.OFFLINE) {
                update.enableOffline();
            } else if (this.strategy == LiveRebelDeployPublisher.Strategy.ROLLING) {
                update.enableRolling();
            }
        }
        update.on(serverIds);
        update.execute();
    }

    DiffResult getDifferences(LiveRebelXml lrXml, String activeVersion) {
        DiffResult diffResult = this.getCommandCenter().compare(lrXml.getApplicationId(), activeVersion, lrXml.getVersionId(), false);
        diffResult.print(this.listener.getLogger());
        this.listener.getLogger().println();
        return diffResult;
    }

    void uploadIfNeeded(ApplicationInfo applicationInfo, String currentVersion, FilePath warFile) throws IOException, InterruptedException {
        if (applicationInfo != null && applicationInfo.getVersions().contains(currentVersion)) {
            this.listener.getLogger().println("Current version of application is already uploaded. Skipping upload.");
        } else {
            this.uploadArtifact(new File(warFile.getRemote()));
            this.listener.getLogger().printf("Artifact uploaded: %s\n", warFile);
        }
    }

    boolean uploadArtifact(File artifact) throws IOException, InterruptedException {
        try {
            UploadInfo upload = this.getCommandCenter().upload(artifact);
            this.listener.getLogger().printf("SUCCESS: %s %s was uploaded.\n", upload.getApplicationId(), upload.getVersionId());
            return true;
        }
        catch (DuplicationException e) {
            this.listener.getLogger().println(e.getMessage());
            return false;
        }
    }

    LiveRebelXml getLiveRebelXml(FilePath warFile) throws IOException, InterruptedException {
        LiveRebelXml lrXml = LiveApplicationUtil.findLiveRebelXml((File)new File(warFile.getRemote()));
        if (lrXml != null) {
            this.listener.getLogger().printf("Found LiveRebel xml. Current application is: %s %s.\n", lrXml.getApplicationId(), lrXml.getVersionId());
            if (lrXml.getApplicationId() == null) {
                throw new RuntimeException("application name is not set in liverebel.xml");
            }
            if (lrXml.getVersionId() == null) {
                throw new RuntimeException("application version is not set in liverebel.xml");
            }
            return lrXml;
        }
        throw new RuntimeException("Didn't find liverebel.xml");
    }

    Set<String> getDeployServers(ApplicationInfo applicationInfo, List<String> selectedServers) {
        HashSet<String> deployServers = new HashSet<String>();
        if (this.isFirstRelease(applicationInfo)) {
            deployServers.addAll(selectedServers);
            return deployServers;
        }
        Map activeVersions = applicationInfo.getActiveVersionPerServer();
        for (String server : selectedServers) {
            if (activeVersions.containsKey(server)) continue;
            deployServers.add(server);
        }
        return deployServers;
    }

    private Level getMaxDifferenceLevel(ApplicationInfo applicationInfo, LiveRebelXml lrXml, Set<String> serversToUpdate) {
        Map activeVersions = applicationInfo.getActiveVersionPerServer();
        Level diffLevel = Level.NOP;
        String versionToUpdateTo = lrXml.getVersionId();
        int serversWithSameVersion = 0;
        for (Map.Entry entry : activeVersions.entrySet()) {
            String server = (String)entry.getKey();
            if (!serversToUpdate.contains(server)) continue;
            String versionInServer = (String)entry.getValue();
            if (StringUtils.equals((String)versionToUpdateTo, (String)versionInServer)) {
                ++serversWithSameVersion;
                serversToUpdate.remove(server);
                this.listener.getLogger().println("Server " + server + " already contains active version " + lrXml.getVersionId() + " of application " + lrXml.getApplicationId());
                continue;
            }
            DiffResult differences = this.getDifferences(lrXml, versionInServer);
            Level maxLevel = differences.getMaxLevel();
            if (maxLevel.compareTo((Enum)diffLevel) <= 0) continue;
            diffLevel = maxLevel;
        }
        if (serversWithSameVersion > 0) {
            String msg = "Cancelling update - version " + lrXml.getVersionId() + " of application " + lrXml.getApplicationId() + " is already deployed to " + serversWithSameVersion + " servers";
            if (!serversToUpdate.isEmpty()) {
                msg = msg + " out of " + (serversToUpdate.size() + serversWithSameVersion) + " servers.";
            }
            throw new RuntimeException(msg);
        }
        return diffLevel;
    }

    public CommandCenter getCommandCenter() {
        return this.commandCenter;
    }
}

