/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jenkins;

import com.zeroturnaround.liverebel.api.CommandCenter;
import com.zeroturnaround.liverebel.api.CommandCenterFactory;
import com.zeroturnaround.liverebel.api.ConnectException;
import com.zeroturnaround.liverebel.api.Forbidden;
import com.zeroturnaround.liverebel.api.ServerInfo;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.zeroturnaround.jenkins.LiveRebelProxy;
import org.zeroturnaround.jenkins.ServerCheckbox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveRebelDeployPublisher
extends Notifier
implements Serializable {
    public final String artifacts;
    public final boolean useFallbackIfCompatibleWithWarnings;
    public final boolean uploadOnly;
    public final Strategy strategy;
    public final String contextPath;
    private final List<ServerCheckbox> servers;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public LiveRebelDeployPublisher(String artifacts, String contextPath, List<ServerCheckbox> servers, String strategy, boolean useFallbackIfCompatibleWithWarnings, boolean uploadOnly) {
        this.contextPath = contextPath;
        this.artifacts = artifacts;
        this.uploadOnly = uploadOnly;
        this.strategy = Strategy.valueOf(strategy);
        this.servers = servers;
        this.useFallbackIfCompatibleWithWarnings = useFallbackIfCompatibleWithWarnings;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        FilePath[] deployableFiles;
        if (!build.getResult().isBetterOrEqualTo(Result.UNSTABLE)) {
            return false;
        }
        if (build.getWorkspace().isRemote()) {
            new ArtifactArchiver(this.artifacts, "", true).perform(build, launcher, listener);
            deployableFiles = new FilePath(build.getArtifactsDir()).list(this.artifacts);
        } else {
            deployableFiles = build.getWorkspace().list(this.artifacts);
        }
        CommandCenterFactory commandCenterFactory = new CommandCenterFactory().setUrl(this.getDescriptor().getLrUrl()).setVerbose(true).authenticate(this.getDescriptor().getAuthToken());
        if (!new LiveRebelProxy(commandCenterFactory, listener).perform(deployableFiles, this.contextPath, this.getDeployableServers(), this.strategy, this.useFallbackIfCompatibleWithWarnings, this.uploadOnly)) {
            build.setResult(Result.FAILURE);
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    private List<String> getDeployableServers() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.servers != null) {
            for (ServerCheckbox server : this.servers) {
                if (!server.isSelected()) continue;
                list.add(server.getServer());
            }
        }
        return list;
    }

    public List<ServerCheckbox> getServers() {
        if (this.servers == null) {
            return this.getDescriptor().getDefaultServers();
        }
        CommandCenter commandCenter = this.getDescriptor().newCommandCenter();
        if (commandCenter != null) {
            Map lrServers = commandCenter.getServers();
            HashMap<String, ServerCheckbox> map = new HashMap<String, ServerCheckbox>();
            for (ServerCheckbox checkbox : this.servers) {
                map.put(checkbox.getServer(), checkbox);
            }
            this.servers.clear();
            for (ServerInfo server : lrServers.values()) {
                boolean checked = map.containsKey(server.getId()) ? ((ServerCheckbox)map.get(server.getId())).isSelected() : false;
                this.servers.add(new ServerCheckbox(server.getId(), server.getName(), checked, server.isConnected()));
            }
        }
        return this.servers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static final Logger LOGGER = Logger.getLogger(DescriptorImpl.class.getName());
        private String authToken;
        private String lrUrl;

        public DescriptorImpl() {
            this.load();
        }

        public String getAuthToken() {
            return this.authToken;
        }

        public String getLrUrl() {
            return this.lrUrl;
        }

        public CommandCenter newCommandCenter() {
            if (this.getLrUrl() == null || this.getAuthToken() == null) {
                LOGGER.warning("Please, navigate to Jenkins Configuration to specify running LiveRebel Url and Authentication Token.");
                return null;
            }
            try {
                CommandCenter commandCenter = new CommandCenterFactory().setUrl(this.getLrUrl()).setVerbose(true).authenticate(this.getAuthToken()).newCommandCenter();
                return commandCenter;
            }
            catch (Forbidden e) {
                LOGGER.warning("ERROR! Access denied. Please, navigate to Jenkins Configuration to specify LiveRebel Authentication Token.");
            }
            catch (ConnectException e) {
                LOGGER.warning("ERROR! Unable to connect to server.");
                LOGGER.log(Level.WARNING, "URL: {0}", e.getURL());
                if (e.getURL().equals("https://")) {
                    LOGGER.warning("Please, navigate to Jenkins Configuration to specify running LiveRebel Url.");
                }
                LOGGER.log(Level.WARNING, "Reason: {0}", e.getMessage());
            }
            return null;
        }

        public List<ServerCheckbox> getDefaultServers() {
            ArrayList<ServerCheckbox> servers = new ArrayList<ServerCheckbox>();
            CommandCenter commandCenter = this.newCommandCenter();
            if (commandCenter != null) {
                for (ServerInfo server : commandCenter.getServers().values()) {
                    servers.add(new ServerCheckbox(server.getId(), server.getName(), false, server.isConnected()));
                }
            }
            return servers;
        }

        public FormValidation doCheckLrUrl(@QueryParameter(value="lrUrl") String value) throws IOException, ServletException {
            if (value != null && value.length() > 0) {
                try {
                    new URL(value);
                }
                catch (Exception e) {
                    return FormValidation.error((String)"Should be a valid URL.");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAuthToken(@QueryParameter(value="authToken") String value) throws IOException, ServletException {
            if (value == null || value.length() != 36) {
                return FormValidation.error((String)"Should be a valid authentication token.");
            }
            return FormValidation.ok();
        }

        public FormValidation doTestConnection(@QueryParameter(value="authToken") String authToken, @QueryParameter(value="lrUrl") String lrUrl) throws IOException, ServletException {
            try {
                new CommandCenterFactory().setUrl(lrUrl).setVerbose(false).authenticate(authToken).newCommandCenter();
                return FormValidation.ok((String)"Success");
            }
            catch (Forbidden e) {
                return FormValidation.error((String)"Please, provide right authentication token!");
            }
            catch (ConnectException e) {
                return FormValidation.error((String)"Could not connect to LiveRebel at (%s)", (Object[])new Object[]{e.getURL()});
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Deploy artifacts with LiveRebel";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.authToken = formData.getString("authToken");
            this.lrUrl = "https://" + formData.getString("lrUrl").replaceFirst("http://", "").replaceFirst("https://", "");
            this.save();
            return super.configure(req, formData);
        }

        public FormValidation doCheckArtifacts(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException, ServletException {
            if (value == null || value.length() == 0) {
                return FormValidation.error((String)"Please, provide at least one artifact.");
            }
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strategy {
        OFFLINE,
        ROLLING;

    }
}

