/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jenkins;

import com.zeroturnaround.liverebel.api.CommandCenter;
import com.zeroturnaround.liverebel.api.CommandCenterFactory;
import com.zeroturnaround.liverebel.api.ServerInfo;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;
import org.zeroturnaround.jenkins.LiveRebelDeployPublisher;
import org.zeroturnaround.jenkins.LiveRebelProxy;
import org.zeroturnaround.jenkins.ServerCheckbox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class LiveRebelDeployPublisher
extends Notifier
implements Serializable {
    public final String artifacts;
    public final boolean useFallbackIfCompatibleWithWarnings;
    public final Strategy strategy;
    private final List<ServerCheckbox> servers;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public LiveRebelDeployPublisher(String artifacts, List<ServerCheckbox> servers, String strategy, boolean useFallbackIfCompatibleWithWarnings) {
        this.artifacts = artifacts;
        this.strategy = Strategy.valueOf((String)strategy);
        this.servers = servers;
        this.useFallbackIfCompatibleWithWarnings = useFallbackIfCompatibleWithWarnings;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        FilePath[] deployableFiles;
        if (!build.getResult().isBetterOrEqualTo(Result.UNSTABLE)) {
            return false;
        }
        if (build.getWorkspace().isRemote()) {
            new ArtifactArchiver(this.artifacts, "", true).perform(build, launcher, listener);
            deployableFiles = new FilePath(build.getArtifactsDir()).list(this.artifacts);
        } else {
            deployableFiles = build.getWorkspace().list(this.artifacts);
        }
        CommandCenterFactory commandCenterFactory = new CommandCenterFactory().setUrl(this.getDescriptor().getLrUrl()).setVerbose(true).authenticate(this.getDescriptor().getAuthToken());
        if (!new LiveRebelProxy(commandCenterFactory, listener).perform(deployableFiles, this.getDeployableServers(), this.strategy, this.useFallbackIfCompatibleWithWarnings)) {
            build.setResult(Result.FAILURE);
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    private List<String> getDeployableServers() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.servers != null) {
            for (ServerCheckbox server : this.servers) {
                if (!server.isSelected()) continue;
                list.add(server.getServer());
            }
        }
        return list;
    }

    public List<ServerCheckbox> getServers() {
        if (this.servers == null) {
            return this.getDescriptor().getDefaultServers();
        }
        CommandCenter commandCenter = this.getDescriptor().newCommandCenter();
        if (commandCenter != null) {
            Map lrServers = commandCenter.getServers();
            HashMap<String, ServerCheckbox> map = new HashMap<String, ServerCheckbox>();
            for (ServerCheckbox checkbox : this.servers) {
                map.put(checkbox.getServer(), checkbox);
            }
            this.servers.clear();
            for (ServerInfo server : lrServers.values()) {
                boolean checked = map.containsKey(server.getId()) ? ((ServerCheckbox)map.get(server.getId())).isSelected() : false;
                this.servers.add(new ServerCheckbox(server.getId(), server.getName(), checked, server.isConnected()));
            }
        }
        return this.servers;
    }
}

