/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jenkins.util;

import com.zeroturnaround.liverebel.api.CommandCenter;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.zeroturnaround.jenkins.LiveRebelDeployBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactAndMetadataDescriptor<T extends Describable<T>>
extends Descriptor<T> {
    public FormValidation doCheckArtifact(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException, ServletException {
        if (StringUtils.trimToNull((String)value) == null || value.length() == 0) {
            return FormValidation.error((String)"Please provide an artifact.");
        }
        if (value.contains(",")) {
            return FormValidation.error((String)"Please provide only one artifact.");
        }
        return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
    }

    public FormValidation doCheckMetadata(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException, ServletException {
        if (StringUtils.trimToNull((String)value) != null) {
            if (value.contains(",")) {
                return FormValidation.error((String)"Please provide only one metadata file.");
            }
            String fileExtension = null;
            try {
                fileExtension = value.substring(value.lastIndexOf(46) + 1);
            }
            catch (Exception e) {
                return FormValidation.error((String)"Metadata must be a text file!");
            }
            if (!fileExtension.equals("txt")) {
                return FormValidation.error((String)"Metadata must be a text file!");
            }
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }
        return FormValidation.ok();
    }

    public boolean isMetadataSupported() {
        CommandCenter cc = LiveRebelDeployBuilder.DescriptorImpl.newCommandCenter();
        return cc != null && !cc.getVersion().equals("2.0");
    }

    public String getDisplayName() {
        throw new UnsupportedOperationException("getDisplayName() should be overridden");
    }
}

