/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jenkins;

import hudson.Extension;
import hudson.model.Hudson;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.zeroturnaround.jenkins.LiveRebelDeployBuilder;
import org.zeroturnaround.jenkins.OverrideForm;
import org.zeroturnaround.jenkins.ServerCheckbox;
import org.zeroturnaround.jenkins.UpdateStrategiesImpl;
import org.zeroturnaround.jenkins.util.ArtifactAndMetadataDescriptor;
import org.zeroturnaround.jenkins.util.ServerConvertUtil;
import org.zeroturnaround.liverebel.plugins.ServersUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployOrUpdate
extends LiveRebelDeployBuilder.ActionWrapper {
    public final String contextPath;
    public final String artifact;
    public final String app;
    public final String ver;
    public final String metadata;
    private String contextPathWithEnvVarReplaced;
    public final UpdateStrategiesImpl updateStrategies;
    public final List<ServerCheckbox> servers;
    public final boolean isOverride;

    @DataBoundConstructor
    public DeployOrUpdate(String contextPath, String artifact, String metadata, UpdateStrategiesImpl updateStrategies, List<ServerCheckbox> servers, OverrideForm overrideForm) {
        this.artifact = StringUtils.trimToNull((String)artifact);
        this.metadata = StringUtils.trimToNull((String)metadata);
        this.contextPath = StringUtils.trimToNull((String)contextPath);
        this.updateStrategies = updateStrategies;
        this.servers = servers;
        if (overrideForm != null) {
            this.app = StringUtils.trimToNull((String)overrideForm.getApp());
            this.ver = StringUtils.trimToNull((String)overrideForm.getVer());
            this.isOverride = true;
        } else {
            this.app = null;
            this.ver = null;
            this.isOverride = false;
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getContextPathWithEnv() {
        if (this.contextPathWithEnvVarReplaced == null) {
            return this.contextPath;
        }
        return this.contextPathWithEnvVarReplaced;
    }

    public void setContextPathWithEnvVarReplaced(String contextPathWithEnvVarReplaced) {
        this.contextPathWithEnvVarReplaced = contextPathWithEnvVarReplaced;
    }

    public String toString() {
        return "{ contextPath=" + this.contextPath + "; updateStrategies=" + this.updateStrategies + "; servers=" + this.servers + " }";
    }

    public List<ServerCheckbox> getServers() {
        return ServerConvertUtil.serverToServerCheckBox(new ServersUtil(LiveRebelDeployBuilder.DescriptorImpl.newCommandCenter(), ServerConvertUtil.serverCheckBoxToServer(this.servers)).getServers());
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptor(this.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends ArtifactAndMetadataDescriptor<LiveRebelDeployBuilder.ActionWrapper> {
        @Override
        public String getDisplayName() {
            return "Deploy or update";
        }

        public List<ServerCheckbox> getDefaultServers() {
            return ServerConvertUtil.serverToServerCheckBox(new ServersUtil(LiveRebelDeployBuilder.DescriptorImpl.newCommandCenter(), null).getDefaultServers());
        }

        public String getUniqueId() {
            return UUID.randomUUID().toString();
        }
    }
}

