/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jenkins;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.zeroturnaround.jenkins.LiveRebelDeployBuilder;
import org.zeroturnaround.jenkins.ServerCheckbox;
import org.zeroturnaround.jenkins.util.ServerConvertUtil;
import org.zeroturnaround.liverebel.plugins.ServersUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Undeploy
extends LiveRebelDeployBuilder.ActionWrapper {
    public final List<ServerCheckbox> servers;
    public final String undeployID;

    @DataBoundConstructor
    public Undeploy(List<ServerCheckbox> servers, String undeployID) {
        this.servers = servers;
        this.undeployID = StringUtils.trimToNull((String)undeployID);
    }

    public List<ServerCheckbox> getServers() {
        return ServerConvertUtil.serverToServerCheckBox(new ServersUtil(LiveRebelDeployBuilder.DescriptorImpl.newCommandCenter(), ServerConvertUtil.serverCheckBoxToServer(this.servers)).getServers());
    }

    public UndeployDescriptorImpl getDescriptor() {
        return (UndeployDescriptorImpl)Hudson.getInstance().getDescriptor(this.getClass());
    }

    public String toString() {
        return "{ servers=" + this.servers + " }";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class UndeployDescriptorImpl
    extends Descriptor<LiveRebelDeployBuilder.ActionWrapper> {
        public String getDisplayName() {
            return "Undeploy";
        }

        public List<ServerCheckbox> getDefaultServers() {
            return ServerConvertUtil.serverToServerCheckBox(new ServersUtil(LiveRebelDeployBuilder.DescriptorImpl.newCommandCenter(), null).getDefaultServers());
        }

        public String getUniqueId() {
            return UUID.randomUUID().toString();
        }
    }
}

