/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jenkins;

import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.zeroturnaround.liverebel.plugins.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerCheckbox
implements Describable<ServerCheckbox>,
Server {
    private final String title;
    private final String id;
    private final String parentNames;
    private final int indentDepth;
    private final boolean checked;
    private final boolean connected;
    private final boolean isGroup;

    @DataBoundConstructor
    public ServerCheckbox(String server, String title, String parentNames, int indentDepth, boolean selected, boolean online, boolean isGroup) {
        this.id = server;
        this.parentNames = parentNames;
        this.indentDepth = indentDepth;
        this.connected = online;
        this.title = title;
        this.checked = selected;
        this.isGroup = isGroup;
    }

    public String getIndentDepthAsCSSClass() {
        switch (this.indentDepth) {
            case 0: {
                return "topLevel";
            }
            case 1: {
                return "firstLevel";
            }
            case 2: {
                return "secondLevel";
            }
            case 3: {
                return "thirdLevel";
            }
        }
        return "";
    }

    public int getIndentDepth() {
        return this.indentDepth;
    }

    public String getParentNames() {
        return StringUtils.trimToEmpty((String)this.parentNames);
    }

    public boolean isGroup() {
        return this.isGroup;
    }

    public String getServer() {
        return this.id;
    }

    public boolean isOnline() {
        return this.connected;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        throw new UnsupportedOperationException("setTitle");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        throw new UnsupportedOperationException("setId");
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        throw new UnsupportedOperationException("setConnected");
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        throw new UnsupportedOperationException("setChecked");
    }

    public boolean isSelected() {
        return this.checked;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptor(this.getClass());
    }

    public String toString() {
        return "{ GROUP_NAME=" + this.getTitle() + " checked=" + this.isSelected() + " isGroup=" + this.isGroup() + " connected=" + this.isOnline() + " parentNames=" + this.parentNames + " }";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<ServerCheckbox> {
        public String getDisplayName() {
            return "Server checkbox";
        }
    }
}

