/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jenkins;

import com.zeroturnaround.liverebel.api.Forbidden;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.zeroturnaround.jenkins.LiveRebelDeployBuilder;
import org.zeroturnaround.jenkins.ServerCheckbox;
import org.zeroturnaround.jenkins.util.ServerConvertUtil;
import org.zeroturnaround.liverebel.plugins.ServersUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Undeploy
extends LiveRebelDeployBuilder.ActionWrapper {
    public final List<ServerCheckbox> servers;
    public final String undeployID;

    @DataBoundConstructor
    public Undeploy(List<ServerCheckbox> servers, String undeployID) {
        this.servers = servers;
        this.undeployID = StringUtils.trimToNull((String)undeployID);
    }

    public List<ServerCheckbox> getServers() {
        return ServerConvertUtil.serverToServerCheckBox(new ServersUtil(LiveRebelDeployBuilder.DescriptorImpl.newCommandCenter(), ServerConvertUtil.serverCheckBoxToServer(this.servers)).getServers());
    }

    public UndeployDescriptorImpl getDescriptor() {
        return (UndeployDescriptorImpl)Hudson.getInstance().getDescriptor(this.getClass());
    }

    public String toString() {
        return "{ servers=" + this.servers + " }";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class UndeployDescriptorImpl
    extends Descriptor<LiveRebelDeployBuilder.ActionWrapper> {
        public String getDisplayName() {
            return "Undeploy";
        }

        public List<ServerCheckbox> getDefaultServers() {
            return ServerConvertUtil.serverToServerCheckBox(new ServersUtil(LiveRebelDeployBuilder.DescriptorImpl.newCommandCenter(), null).getDefaultServers());
        }

        public String getUniqueId() {
            return UUID.randomUUID().toString();
        }

        public FormValidation doCheckTestServers() throws IOException, ServletException {
            try {
                List<ServerCheckbox> availableServers = this.getDefaultServers();
                if (availableServers.isEmpty()) {
                    return FormValidation.error((String)"No connected servers!");
                }
                boolean anyOnline = false;
                for (ServerCheckbox serverCheckbox : availableServers) {
                    if (!serverCheckbox.isConnected()) continue;
                    anyOnline = true;
                }
                if (!anyOnline) {
                    return FormValidation.warning((String)"No online servers!");
                }
            }
            catch (Forbidden e) {
                if (e.getMessage().contains("MANAGE_GROUPS")) {
                    return FormValidation.error((String)"User whose authentication token is used must have MANAGE_GROUPS permission!");
                }
                throw e;
            }
            return FormValidation.ok();
        }
    }
}

