/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jenkins;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;
import org.zeroturnaround.jenkins.updateModes.FailBuild;
import org.zeroturnaround.jenkins.updateModes.FullRestart;
import org.zeroturnaround.jenkins.updateModes.Hotpatch;
import org.zeroturnaround.jenkins.updateModes.LiveRebelDefault;
import org.zeroturnaround.jenkins.updateModes.RollingRestarts;
import org.zeroturnaround.jenkins.updateModes.UpdateMode;
import org.zeroturnaround.liverebel.plugins.UpdateStrategies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateStrategiesImpl
implements Describable<UpdateStrategiesImpl>,
UpdateStrategies {
    public final org.zeroturnaround.liverebel.plugins.UpdateMode primary;
    public org.zeroturnaround.liverebel.plugins.UpdateMode fallback;
    public boolean updateWithWarnings;
    public int sessionDrainTimeout;
    public int requestPauseTimeout;
    public int connectionPauseTimeout;
    public final UpdateMode updateMode;

    @DataBoundConstructor
    public UpdateStrategiesImpl(UpdateMode updateMode) {
        this.updateMode = updateMode;
        if (updateMode instanceof RollingRestarts) {
            this.primary = org.zeroturnaround.liverebel.plugins.UpdateMode.ROLLING_RESTARTS;
            this.sessionDrainTimeout = ((RollingRestarts)updateMode).sessionDrain;
        } else if (updateMode instanceof Hotpatch) {
            this.primary = org.zeroturnaround.liverebel.plugins.UpdateMode.HOTPATCH;
            this.setHotpatchConf((Hotpatch)updateMode);
        } else if (updateMode instanceof FullRestart) {
            this.primary = org.zeroturnaround.liverebel.plugins.UpdateMode.OFFLINE;
            this.connectionPauseTimeout = ((FullRestart)updateMode).connectionPause;
        } else {
            this.primary = org.zeroturnaround.liverebel.plugins.UpdateMode.LIVEREBEL_DEFAULT;
        }
        this.checkAndSetDefaultTimeouts();
    }

    private void checkAndSetDefaultTimeouts() {
        if (this.requestPauseTimeout == 0) {
            this.requestPauseTimeout = 30;
        }
        if (this.connectionPauseTimeout == 0) {
            this.connectionPauseTimeout = 30;
        }
        if (this.sessionDrainTimeout == 0) {
            this.sessionDrainTimeout = 3600;
        }
    }

    private void setHotpatchConf(Hotpatch updateMode) {
        this.fallback = this.getFallback(updateMode.fallback);
        if (this.fallback == org.zeroturnaround.liverebel.plugins.UpdateMode.ROLLING_RESTARTS) {
            this.sessionDrainTimeout = ((RollingRestarts)updateMode.fallback).sessionDrain;
        } else if (this.fallback == org.zeroturnaround.liverebel.plugins.UpdateMode.OFFLINE) {
            this.connectionPauseTimeout = ((FullRestart)updateMode.fallback).connectionPause;
        }
        this.updateWithWarnings = updateMode.updateWithWarnings;
        this.requestPauseTimeout = updateMode.requestPause;
    }

    private org.zeroturnaround.liverebel.plugins.UpdateMode getFallback(UpdateMode updateMode) {
        if (updateMode instanceof RollingRestarts) {
            return org.zeroturnaround.liverebel.plugins.UpdateMode.ROLLING_RESTARTS;
        }
        if (updateMode instanceof FullRestart) {
            return org.zeroturnaround.liverebel.plugins.UpdateMode.OFFLINE;
        }
        if (updateMode instanceof FailBuild) {
            return org.zeroturnaround.liverebel.plugins.UpdateMode.FAIL_BUILD;
        }
        if (updateMode instanceof LiveRebelDefault) {
            return org.zeroturnaround.liverebel.plugins.UpdateMode.LIVEREBEL_DEFAULT;
        }
        return org.zeroturnaround.liverebel.plugins.UpdateMode.LIVEREBEL_DEFAULT;
    }

    public org.zeroturnaround.liverebel.plugins.UpdateMode getPrimaryUpdateStrategy() {
        return this.primary;
    }

    public org.zeroturnaround.liverebel.plugins.UpdateMode getFallbackUpdateStrategy() {
        return this.fallback;
    }

    public boolean updateWithWarnings() {
        return this.updateWithWarnings;
    }

    public int getSessionDrainTimeout() {
        return this.sessionDrainTimeout;
    }

    public int getRequestPauseTimeout() {
        return this.requestPauseTimeout;
    }

    public int getConnectionPauseTimeout() {
        return this.connectionPauseTimeout;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptor(this.getClass());
    }

    public String toString() {
        return "UpdateStrategiesImpl{primary=" + this.primary + ", fallback=" + this.fallback + ", updateWithWarnings=" + this.updateWithWarnings + ", sessionDrainTimeout=" + this.sessionDrainTimeout + ", requestPauseTimeout=" + this.requestPauseTimeout + ", connectionPauseTimeout=" + this.connectionPauseTimeout + ", updateMode=" + this.updateMode + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<UpdateStrategiesImpl> {
        public String getDisplayName() {
            return "Update Strategies info";
        }

        public Descriptor<UpdateMode> getDefaultPrimaryUpdate() {
            DescriptorExtensionList allDescriptors = Hudson.getInstance().getDescriptorList(UpdateMode.class);
            for (Descriptor next : allDescriptors) {
                if (next.clazz != LiveRebelDefault.class) continue;
                return next;
            }
            return null;
        }

        public List<Descriptor<UpdateMode>> getPrimaryUpdateModes() {
            DescriptorExtensionList allDescriptors = Hudson.getInstance().getDescriptorList(UpdateMode.class);
            ArrayList<Descriptor<UpdateMode>> primaryUpdateModes = new ArrayList<Descriptor<UpdateMode>>();
            for (Descriptor next : allDescriptors) {
                if (next.clazz == FailBuild.class) continue;
                primaryUpdateModes.add((Descriptor<UpdateMode>)next);
            }
            return primaryUpdateModes;
        }
    }
}

