/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jenkins;

import com.zeroturnaround.liverebel.api.CommandCenterFactory;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.zeroturnaround.jenkins.DeployOrUpdate;
import org.zeroturnaround.jenkins.LiveRebelDeployBuilder;
import org.zeroturnaround.jenkins.ServerCheckbox;
import org.zeroturnaround.jenkins.Undeploy;
import org.zeroturnaround.jenkins.UpdateStrategiesImpl;
import org.zeroturnaround.jenkins.Upload;
import org.zeroturnaround.jenkins.updateModes.LiveRebelDefault;
import org.zeroturnaround.jenkins.updateModes.UpdateMode;
import org.zeroturnaround.jenkins.util.HudsonLogger;
import org.zeroturnaround.liverebel.plugins.PluginConf;
import org.zeroturnaround.liverebel.plugins.PluginLogger;
import org.zeroturnaround.liverebel.plugins.PluginUtil;
import org.zeroturnaround.liverebel.plugins.UpdateStrategies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class LiveRebelDeployBuilder
extends Builder
implements Serializable {
    public final DeployOrUpdate deployOrUpdate;
    public final Undeploy undeploy;
    public final Upload upload;
    public final ActionWrapper action;
    private final PluginConf conf;
    private static final Logger LOGGER = Logger.getLogger(LiveRebelDeployBuilder.class.getName());
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public LiveRebelDeployBuilder(ActionWrapper action) {
        this.action = action;
        if (action instanceof Undeploy) {
            this.undeploy = (Undeploy)action;
            this.upload = null;
            this.deployOrUpdate = null;
            this.conf = new PluginConf(PluginConf.Action.UNDEPLOY);
        } else if (action instanceof Upload) {
            this.upload = (Upload)action;
            this.undeploy = null;
            this.deployOrUpdate = null;
            this.conf = new PluginConf(PluginConf.Action.UPLOAD);
        } else if (action instanceof DeployOrUpdate) {
            this.undeploy = null;
            this.upload = null;
            this.deployOrUpdate = (DeployOrUpdate)action;
            this.conf = new PluginConf(PluginConf.Action.DEPLOY_OR_UPDATE);
        } else {
            this.upload = (Upload)action;
            this.undeploy = null;
            this.deployOrUpdate = null;
            this.conf = new PluginConf(PluginConf.Action.UPLOAD);
        }
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        switch (1.$SwitchMap$org$zeroturnaround$liverebel$plugins$PluginConf$Action[this.conf.getAction().ordinal()]) {
            case 1: {
                this.conf.deployable = this.getArtificatOrMetadata(envVars.expand(this.upload.artifact), build, launcher, listener);
                this.conf.metadata = this.getArtificatOrMetadata(envVars.expand(this.upload.metadata), build, launcher, listener);
                if (!this.upload.isOverride) break;
                this.conf.isOverride = true;
                this.conf.overrideApp = envVars.expand(this.upload.app);
                this.conf.overrideVer = envVars.expand(this.upload.ver);
                break;
            }
            case 2: {
                this.conf.deployable = this.getArtificatOrMetadata(envVars.expand(this.deployOrUpdate.artifact), build, launcher, listener);
                this.conf.metadata = this.getArtificatOrMetadata(envVars.expand(this.deployOrUpdate.metadata), build, launcher, listener);
                Object object = this.conf.updateStrategies = this.deployOrUpdate.updateStrategies == null ? this.getDefaultUpdateStrategies() : this.deployOrUpdate.updateStrategies;
                if (this.deployOrUpdate.isOverride) {
                    this.conf.isOverride = true;
                    this.conf.overrideApp = envVars.expand(this.deployOrUpdate.app);
                    this.conf.overrideVer = envVars.expand(this.deployOrUpdate.ver);
                }
                this.conf.serverIds = this.getDeployableServers();
                this.conf.contextPath = envVars.expand(this.deployOrUpdate.contextPath);
                break;
            }
            case 3: {
                this.conf.undeployId = envVars.expand(this.undeploy.undeployID);
                this.conf.serverIds = this.getDeployableServers();
            }
        }
        CommandCenterFactory commandCenterFactory = this.getCommandCenterFactory();
        PluginUtil pluginUtil = new PluginUtil(commandCenterFactory, (PluginLogger)new HudsonLogger(listener));
        if (pluginUtil.perform(this.conf) != PluginUtil.PluginActionResult.SUCCESS) {
            build.setResult(Result.FAILURE);
        }
        return true;
    }

    private UpdateStrategies getDefaultUpdateStrategies() {
        UpdateStrategiesImpl updateStrategies = new UpdateStrategiesImpl((UpdateMode)new LiveRebelDefault());
        updateStrategies.updateWithWarnings = false;
        updateStrategies.requestPauseTimeout = 30;
        updateStrategies.sessionDrainTimeout = 3600;
        return updateStrategies;
    }

    private File getArtificatOrMetadata(String artifact, AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException {
        FilePath deployableFile;
        if (artifact == null) {
            return null;
        }
        if (build.getWorkspace().isRemote()) {
            new ArtifactArchiver(artifact, "", true).perform(build, launcher, listener);
            deployableFile = new FilePath(build.getArtifactsDir()).child(artifact);
        } else {
            deployableFile = build.getWorkspace().child(artifact);
        }
        return new File(deployableFile.getRemote());
    }

    protected CommandCenterFactory getCommandCenterFactory() {
        CommandCenterFactory commandCenterFactory = new CommandCenterFactory();
        this.getDescriptor();
        CommandCenterFactory commandCenterFactory2 = commandCenterFactory.setUrl(DescriptorImpl.getLrUrl()).setVerbose(true);
        this.getDescriptor();
        return commandCenterFactory2.authenticate(DescriptorImpl.getAuthToken());
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptor(this.getClass());
    }

    private List<String> getDeployableServers() {
        ArrayList<String> list;
        block4: {
            block3: {
                list = new ArrayList<String>();
                if (!this.conf.getAction().equals((Object)PluginConf.Action.DEPLOY_OR_UPDATE)) break block3;
                if (this.deployOrUpdate == null || this.deployOrUpdate.servers == null) break block4;
                for (ServerCheckbox server : this.deployOrUpdate.servers) {
                    if (!server.isChecked() || server.isGroup() || !server.isConnected()) continue;
                    list.add(server.getId());
                }
                break block4;
            }
            if (this.conf.getAction().equals((Object)PluginConf.Action.UNDEPLOY) && this.undeploy != null && this.undeploy.servers != null) {
                for (ServerCheckbox server : this.undeploy.servers) {
                    if (!server.isChecked() || server.isGroup() || !server.isConnected()) continue;
                    list.add(server.getId());
                }
            }
        }
        return list;
    }
}

