/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jenkins;

import hudson.model.Describable;
import hudson.model.Hudson;
import org.kohsuke.stapler.DataBoundConstructor;
import org.zeroturnaround.jenkins.UpdateStrategiesImpl;
import org.zeroturnaround.jenkins.updateModes.FailBuild;
import org.zeroturnaround.jenkins.updateModes.FullRestart;
import org.zeroturnaround.jenkins.updateModes.Hotpatch;
import org.zeroturnaround.jenkins.updateModes.LiveRebelDefault;
import org.zeroturnaround.jenkins.updateModes.RollingRestarts;
import org.zeroturnaround.jenkins.updateModes.UpdateMode;
import org.zeroturnaround.liverebel.plugins.UpdateStrategies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateStrategiesImpl
implements Describable<UpdateStrategiesImpl>,
UpdateStrategies {
    public final org.zeroturnaround.liverebel.plugins.UpdateMode primary;
    public org.zeroturnaround.liverebel.plugins.UpdateMode fallback;
    public boolean updateWithWarnings;
    public int sessionDrainTimeout;
    public int requestPauseTimeout;
    public final UpdateMode updateMode;

    @DataBoundConstructor
    public UpdateStrategiesImpl(UpdateMode updateMode) {
        this.updateMode = updateMode;
        if (updateMode instanceof RollingRestarts) {
            this.primary = org.zeroturnaround.liverebel.plugins.UpdateMode.ROLLING_RESTARTS;
            this.sessionDrainTimeout = ((RollingRestarts)updateMode).sessionDrain;
            if (this.sessionDrainTimeout == 0) {
                this.sessionDrainTimeout = 3600;
            }
        } else if (updateMode instanceof Hotpatch) {
            this.primary = org.zeroturnaround.liverebel.plugins.UpdateMode.HOTPATCH;
            this.fallback = this.getFallback(((Hotpatch)updateMode).fallback);
            this.updateWithWarnings = ((Hotpatch)updateMode).updateWithWarnings;
            this.requestPauseTimeout = ((Hotpatch)updateMode).requestPause;
            if (this.requestPauseTimeout == 0) {
                this.requestPauseTimeout = 30;
            }
        } else {
            this.primary = updateMode instanceof FullRestart ? org.zeroturnaround.liverebel.plugins.UpdateMode.OFFLINE : org.zeroturnaround.liverebel.plugins.UpdateMode.LIVEREBEL_DEFAULT;
        }
    }

    private org.zeroturnaround.liverebel.plugins.UpdateMode getFallback(UpdateMode updateMode) {
        if (updateMode instanceof RollingRestarts) {
            return org.zeroturnaround.liverebel.plugins.UpdateMode.ROLLING_RESTARTS;
        }
        if (updateMode instanceof FullRestart) {
            return org.zeroturnaround.liverebel.plugins.UpdateMode.OFFLINE;
        }
        if (updateMode instanceof FailBuild) {
            return org.zeroturnaround.liverebel.plugins.UpdateMode.FAIL_BUILD;
        }
        if (updateMode instanceof LiveRebelDefault) {
            return org.zeroturnaround.liverebel.plugins.UpdateMode.LIVEREBEL_DEFAULT;
        }
        return org.zeroturnaround.liverebel.plugins.UpdateMode.LIVEREBEL_DEFAULT;
    }

    public org.zeroturnaround.liverebel.plugins.UpdateMode getPrimaryUpdateStrategy() {
        return this.primary;
    }

    public org.zeroturnaround.liverebel.plugins.UpdateMode getFallbackUpdateStrategy() {
        return this.fallback;
    }

    public boolean updateWithWarnings() {
        return this.updateWithWarnings;
    }

    public int getSessionDrainTimeout() {
        return this.sessionDrainTimeout;
    }

    public int getRequestPauseTimeout() {
        return this.requestPauseTimeout;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptor(this.getClass());
    }
}

