/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jenkins;

import com.zeroturnaround.liverebel.api.CommandCenter;
import com.zeroturnaround.liverebel.api.CommandCenterFactory;
import com.zeroturnaround.liverebel.api.ConnectException;
import com.zeroturnaround.liverebel.api.Forbidden;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.zeroturnaround.jenkins.DeployOrUpdate;
import org.zeroturnaround.jenkins.ServerCheckbox;
import org.zeroturnaround.jenkins.Undeploy;
import org.zeroturnaround.jenkins.UpdateStrategiesImpl;
import org.zeroturnaround.jenkins.Upload;
import org.zeroturnaround.jenkins.updateModes.LiveRebelDefault;
import org.zeroturnaround.jenkins.util.HudsonLogger;
import org.zeroturnaround.liverebel.plugins.PluginConf;
import org.zeroturnaround.liverebel.plugins.PluginLogger;
import org.zeroturnaround.liverebel.plugins.PluginUtil;
import org.zeroturnaround.liverebel.plugins.UpdateStrategies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveRebelDeployBuilder
extends Builder
implements Serializable {
    public final DeployOrUpdate deployOrUpdate;
    public final Undeploy undeploy;
    public final Upload upload;
    public final ActionWrapper action;
    private final PluginConf conf;
    private static final Logger LOGGER = Logger.getLogger(LiveRebelDeployBuilder.class.getName());
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public LiveRebelDeployBuilder(ActionWrapper action) {
        this.action = action;
        if (action instanceof Undeploy) {
            this.undeploy = (Undeploy)action;
            this.upload = null;
            this.deployOrUpdate = null;
            this.conf = new PluginConf(PluginConf.Action.UNDEPLOY);
        } else if (action instanceof Upload) {
            this.upload = (Upload)action;
            this.undeploy = null;
            this.deployOrUpdate = null;
            this.conf = new PluginConf(PluginConf.Action.UPLOAD);
        } else if (action instanceof DeployOrUpdate) {
            this.undeploy = null;
            this.upload = null;
            this.deployOrUpdate = (DeployOrUpdate)action;
            this.conf = new PluginConf(PluginConf.Action.DEPLOY_OR_UPDATE);
        } else {
            this.upload = (Upload)action;
            this.undeploy = null;
            this.deployOrUpdate = null;
            this.conf = new PluginConf(PluginConf.Action.UPLOAD);
        }
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        switch (this.conf.getAction()) {
            case UPLOAD: {
                this.conf.deployable = this.getArtificatOrMetadata(envVars.expand(this.upload.artifact), build, launcher, listener);
                this.conf.metadata = this.getArtificatOrMetadata(envVars.expand(this.upload.metadata), build, launcher, listener);
                if (!this.upload.isOverride) break;
                this.conf.isOverride = true;
                this.conf.overrideApp = envVars.expand(this.upload.app);
                this.conf.overrideVer = envVars.expand(this.upload.ver);
                break;
            }
            case DEPLOY_OR_UPDATE: {
                this.conf.deployable = this.getArtificatOrMetadata(envVars.expand(this.deployOrUpdate.artifact), build, launcher, listener);
                this.conf.metadata = this.getArtificatOrMetadata(envVars.expand(this.deployOrUpdate.metadata), build, launcher, listener);
                Object object = this.conf.updateStrategies = this.deployOrUpdate.updateStrategies == null ? this.getDefaultUpdateStrategies() : this.deployOrUpdate.updateStrategies;
                if (this.deployOrUpdate.isOverride) {
                    this.conf.isOverride = true;
                    this.conf.overrideApp = envVars.expand(this.deployOrUpdate.app);
                    this.conf.overrideVer = envVars.expand(this.deployOrUpdate.ver);
                }
                this.conf.serverIds = this.getDeployableServers();
                this.conf.contextPath = envVars.expand(this.deployOrUpdate.contextPath);
                break;
            }
            case UNDEPLOY: {
                this.conf.undeployId = envVars.expand(this.undeploy.undeployID);
                this.conf.serverIds = this.getDeployableServers();
            }
        }
        CommandCenterFactory commandCenterFactory = this.getCommandCenterFactory();
        PluginUtil pluginUtil = new PluginUtil(commandCenterFactory, (PluginLogger)new HudsonLogger(listener));
        if (pluginUtil.perform(this.conf) != PluginUtil.PluginActionResult.SUCCESS) {
            build.setResult(Result.FAILURE);
        }
        return true;
    }

    private UpdateStrategies getDefaultUpdateStrategies() {
        UpdateStrategiesImpl updateStrategies = new UpdateStrategiesImpl(new LiveRebelDefault());
        updateStrategies.updateWithWarnings = false;
        updateStrategies.requestPauseTimeout = 30;
        updateStrategies.sessionDrainTimeout = 3600;
        return updateStrategies;
    }

    private File getArtificatOrMetadata(String artifact, AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException {
        FilePath deployableFile;
        if (artifact == null) {
            return null;
        }
        if (build.getWorkspace().isRemote()) {
            new ArtifactArchiver(artifact, "", true).perform(build, launcher, listener);
            deployableFile = new FilePath(build.getArtifactsDir()).child(artifact);
        } else {
            deployableFile = build.getWorkspace().child(artifact);
        }
        return new File(deployableFile.getRemote());
    }

    protected CommandCenterFactory getCommandCenterFactory() {
        CommandCenterFactory commandCenterFactory = new CommandCenterFactory();
        this.getDescriptor();
        CommandCenterFactory commandCenterFactory2 = commandCenterFactory.setUrl(DescriptorImpl.getLrUrl()).setVerbose(true);
        this.getDescriptor();
        return commandCenterFactory2.authenticate(DescriptorImpl.getAuthToken());
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptor(this.getClass());
    }

    private List<String> getDeployableServers() {
        ArrayList<String> list;
        block4: {
            block3: {
                list = new ArrayList<String>();
                if (!this.conf.getAction().equals((Object)PluginConf.Action.DEPLOY_OR_UPDATE)) break block3;
                if (this.deployOrUpdate == null || this.deployOrUpdate.servers == null) break block4;
                for (ServerCheckbox server : this.deployOrUpdate.servers) {
                    if (!server.isChecked() || server.isGroup() || !server.isConnected()) continue;
                    list.add(server.getId());
                }
                break block4;
            }
            if (this.conf.getAction().equals((Object)PluginConf.Action.UNDEPLOY) && this.undeploy != null && this.undeploy.servers != null) {
                for (ServerCheckbox server : this.undeploy.servers) {
                    if (!server.isChecked() || server.isGroup() || !server.isConnected()) continue;
                    list.add(server.getId());
                }
            }
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ActionWrapper
    implements Describable<ActionWrapper> {
        public Descriptor<ActionWrapper> getDescriptor() {
            return Hudson.getInstance().getDescriptor(this.getClass());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ActionWrapperDescriptor
        extends Descriptor<ActionWrapper> {
            public ActionWrapperDescriptor(Class<? extends ActionWrapper> clazz) {
                super(clazz);
            }

            public String getDisplayName() {
                try {
                    return ((ActionWrapper)this.clazz.newInstance()).toString();
                }
                catch (InstantiationException ignored) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                return this.clazz.getSimpleName();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private static final Logger LOGGER = Logger.getLogger(DescriptorImpl.class.getName());
        public static String staticAuthToken;
        public static String staticLrUrl;
        private String authToken;
        private String lrUrl;

        public DescriptorImpl() {
            this.load();
            staticAuthToken = this.authToken;
            staticLrUrl = this.lrUrl;
        }

        public static String getAuthToken() {
            return staticAuthToken;
        }

        public static String getLrUrl() {
            return staticLrUrl;
        }

        public static CommandCenter newCommandCenter() {
            if (DescriptorImpl.getLrUrl() == null || DescriptorImpl.getAuthToken() == null) {
                LOGGER.warning("Please, navigate to Jenkins Configuration to specify running LiveRebel Url and Authentication Token.");
                return null;
            }
            try {
                return new CommandCenterFactory().setUrl(DescriptorImpl.getLrUrl()).setVerbose(true).authenticate(DescriptorImpl.getAuthToken()).newCommandCenter();
            }
            catch (Forbidden e) {
                LOGGER.warning("ERROR! Access denied. Please, navigate to Jenkins Configuration to specify LiveRebel Authentication Token.");
            }
            catch (ConnectException e) {
                LOGGER.warning("ERROR! Unable to connect to server.");
                LOGGER.log(Level.WARNING, "URL: {0}", e.getURL());
                if (e.getURL().equals("https://")) {
                    LOGGER.warning("Please, navigate to Jenkins Configuration to specify running LiveRebel Url.");
                }
                LOGGER.log(Level.WARNING, "Reason: {0}", e.getMessage());
            }
            return null;
        }

        public FormValidation doCheckLrUrl(@QueryParameter(value="lrUrl") String value) throws IOException, ServletException {
            if (value != null && value.length() > 0) {
                try {
                    new URL(value);
                }
                catch (Exception e) {
                    return FormValidation.error((String)"Should be a valid URL.");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckAuthToken(@QueryParameter(value="authToken") String value) throws IOException, ServletException {
            if (value == null || value.length() != 36) {
                return FormValidation.error((String)"Should be a valid authentication token.");
            }
            return FormValidation.ok();
        }

        public FormValidation doTestConnection(@QueryParameter(value="authToken") String authToken, @QueryParameter(value="lrUrl") String lrUrl) throws IOException, ServletException {
            try {
                new CommandCenterFactory().setUrl(lrUrl).setVerbose(false).authenticate(authToken).newCommandCenter();
                return FormValidation.ok((String)"Success");
            }
            catch (Forbidden e) {
                return FormValidation.error((String)"Please, provide right authentication token!");
            }
            catch (ConnectException e) {
                return FormValidation.error((String)"Could not connect to LiveRebel at (%s)", (Object[])new Object[]{e.getURL()});
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Deploy or Update artifact with LiveRebel";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.authToken = formData.getString("authToken");
            this.lrUrl = "https://" + formData.getString("lrUrl").replaceFirst("http://", "").replaceFirst("https://", "");
            staticAuthToken = this.authToken;
            staticLrUrl = this.lrUrl;
            this.save();
            return super.configure(req, formData);
        }

        public DescriptorExtensionList<ActionWrapper, Descriptor<ActionWrapper>> getActions() {
            return Hudson.getInstance().getDescriptorList(ActionWrapper.class);
        }
    }
}

