/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.locale;

import com.thoughtworks.xstream.XStream;
import hudson.Plugin;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jvnet.localizer.LocaleProvider;

public class PluginImpl
extends Plugin {
    private String systemLocale;
    private boolean ignoreAcceptLanguage;
    private final transient Locale originalLocale = Locale.getDefault();
    private static final XStream XSTREAM = new XStream2();

    public void start() throws Exception {
        this.load();
        LocaleProvider.setProvider((LocaleProvider)new LocaleProvider(){
            LocaleProvider original = LocaleProvider.getProvider();

            public Locale get() {
                if (PluginImpl.this.ignoreAcceptLanguage) {
                    return Locale.getDefault();
                }
                return this.original.get();
            }
        });
    }

    private void load() throws IOException {
        XmlFile xml = this.getConfigXml();
        if (xml.exists()) {
            xml.unmarshal((Object)this);
        }
        this.setSystemLocale(this.systemLocale);
    }

    private void save() throws IOException {
        this.getConfigXml().write((Object)this);
    }

    private XmlFile getConfigXml() {
        return new XmlFile(XSTREAM, new File(Hudson.getInstance().getRootDir(), "locale.xml"));
    }

    public void configure(JSONObject jsonObject) throws IOException, ServletException, Descriptor.FormException {
        this.setSystemLocale(jsonObject.getString("systemLocale"));
        this.ignoreAcceptLanguage = jsonObject.getBoolean("ignoreAcceptLanguage");
        this.save();
    }

    public boolean isIgnoreAcceptLanguage() {
        return this.ignoreAcceptLanguage;
    }

    public String getSystemLocale() {
        return this.systemLocale;
    }

    public void setSystemLocale(String systemLocale) throws IOException {
        Locale.setDefault((systemLocale = Util.fixEmptyAndTrim((String)systemLocale)) == null ? this.originalLocale : PluginImpl.parse(systemLocale));
        this.systemLocale = systemLocale;
    }

    public static Locale parse(String s) {
        String[] tokens = s.trim().split("_");
        switch (tokens.length) {
            case 1: {
                return new Locale(tokens[0]);
            }
            case 2: {
                return new Locale(tokens[0], tokens[1]);
            }
            case 3: {
                return new Locale(tokens[0], tokens[1], tokens[2]);
            }
        }
        throw new IllegalArgumentException(s + " is not a valid locale");
    }

    static {
        XSTREAM.alias("locale", PluginImpl.class);
    }
}

