/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.lockedfilesreport;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.plugins.lockedfilesreport.FindFilesInUseCommand;
import hudson.plugins.lockedfilesreport.FindFilesInUseWithHandle;
import hudson.plugins.lockedfilesreport.FindFilesInUseWithLsof;
import hudson.plugins.lockedfilesreport.LockedFilesReportAction;
import hudson.plugins.lockedfilesreport.LockedFilesReporter;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockedFilesReporter
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public LockedFilesReporter() {
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return this.checkForFileUsage(build, listener, launcher);
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return this.checkForFileUsage(build, listener, build.getBuiltOn().createLauncher((TaskListener)listener));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private boolean checkForFileUsage(AbstractBuild<?, ?> build, BuildListener listener, Launcher launcher) {
        if (build.getResult().isWorseOrEqualTo(Result.FAILURE) || build.getAction(LockedFilesReportAction.class) != null) {
            return true;
        }
        Object command = launcher.isUnix() ? new FindFilesInUseWithLsof() : new FindFilesInUseWithHandle(this.getDescriptor().getHandleExecutable());
        try {
            listener.getLogger().println("Searching for locked files in workspace.");
            FilePath workspace = build.getBuiltOn().getWorkspaceFor((TopLevelItem)build.getProject());
            List list = (List)workspace.act((FilePath.FileCallable)new GetUsedFiles((FindFilesInUseCommand)command, new StreamBuildListener(listener.getLogger())));
            if (list.size() > 0) {
                build.getActions().add(new LockedFilesReportAction(build, list));
                listener.error("Build was failed as the workspace contained files that were locked by another process. See Locked files report for more information.");
                build.setResult(Result.FAILURE);
            }
            return list.size() == 0;
        }
        catch (IOException e) {
            listener.error("There was an IOException while launching a process. Please report it to the Hudson user mailing list.");
            e.printStackTrace(listener.getLogger());
        }
        catch (InterruptedException e) {
            listener.error("There was an InterruptedException while running a process. Please report it to the Hudson user mailing list.");
            e.printStackTrace(listener.getLogger());
        }
        return false;
    }
}

