/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.locksandlatches;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Resource;
import hudson.model.ResourceActivity;
import hudson.model.ResourceList;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockWrapper
extends BuildWrapper
implements ResourceActivity {
    private List<LockWaitConfig> locks;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final Logger LOGGER = Logger.getLogger(LockWrapper.class.getName());

    public LockWrapper(List<LockWaitConfig> locks) {
        this.locks = locks;
    }

    public List<LockWaitConfig> getLocks() {
        return this.locks;
    }

    public void setLocks(List<LockWaitConfig> locks) {
        this.locks = locks;
    }

    public Descriptor<BuildWrapper> getDescriptor() {
        return DESCRIPTOR;
    }

    public ResourceList getResourceList() {
        ResourceList resources = new ResourceList();
        for (LockWaitConfig lock : this.locks) {
            resources.w(new Resource(null, "locks-and-latches/lock/" + lock.getName(), DESCRIPTOR.getWriteLockCount()));
        }
        return resources;
    }

    public BuildWrapper.Environment setUp(AbstractBuild abstractBuild, Launcher launcher, BuildListener buildListener) throws IOException, InterruptedException {
        return new BuildWrapper.Environment(){};
    }

    public BuildWrapper.Environment setUp(Build build, Launcher launcher, BuildListener buildListener) throws IOException, InterruptedException {
        return this.setUp((AbstractBuild)build, launcher, buildListener);
    }

    public String getDisplayName() {
        return DESCRIPTOR.getDisplayName();
    }

    public static final class LockWaitConfig
    implements Serializable {
        private String name;
        private transient LockConfig lock;

        public LockWaitConfig() {
        }

        @DataBoundConstructor
        public LockWaitConfig(String name) {
            this.name = name;
        }

        public LockConfig getLock() {
            if (this.lock == null && this.name != null && !"".equals(this.name)) {
                this.setLock(DESCRIPTOR.getLock(this.name));
            }
            return this.lock;
        }

        public void setLock(LockConfig lock) {
            this.lock = lock;
        }

        public String getName() {
            if (this.lock == null) {
                return this.name;
            }
            this.name = this.lock.getName();
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.setLock(DESCRIPTOR.getLock(this.name));
        }
    }

    public static final class LockConfig
    implements Serializable {
        private String name;
        private transient AbstractBuild owner = null;

        public LockConfig() {
        }

        @DataBoundConstructor
        public LockConfig(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LockConfig that = (LockConfig)o;
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<BuildWrapper> {
        private List<LockConfig> locks;
        private Integer writeLockCount = null;

        DescriptorImpl() {
            super(LockWrapper.class);
            this.load();
        }

        public String getDisplayName() {
            return "Locks";
        }

        public BuildWrapper newInstance(StaplerRequest req) throws Descriptor.FormException {
            List locks = req.bindParametersToList(LockWaitConfig.class, "locks.locks.");
            return new LockWrapper(locks);
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            req.bindParameters((Object)this, "locks.");
            this.locks = req.bindParametersToList(LockConfig.class, "locks.lock.");
            this.save();
            return super.configure(req);
        }

        public List<LockConfig> getLocks() {
            if (this.locks == null) {
                this.locks = new ArrayList<LockConfig>();
                this.locks.add(new LockConfig("(default)"));
            }
            return this.locks;
        }

        public void setLocks(List<LockConfig> locks) {
            this.locks = locks;
        }

        public LockConfig getLock(String name) {
            for (LockConfig host : this.locks) {
                if (!name.equals(host.getName())) continue;
                return host;
            }
            return null;
        }

        public String[] getLockNames() {
            this.getLocks();
            String[] result = new String[this.locks.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.locks.get(i).getName();
            }
            return result;
        }

        public void addLock(LockConfig hostConfig) {
            this.locks.add(hostConfig);
            this.save();
        }

        synchronized int getWriteLockCount() {
            if (this.writeLockCount == null) {
                Resource a = new Resource(null, "a", 1);
                Resource b = new Resource(null, "a", 1);
                ResourceList c = new ResourceList();
                c.w(a);
                ResourceList d = new ResourceList();
                d.w(b);
                this.writeLockCount = !c.isCollidingWith(d) ? Integer.valueOf(5) : Integer.valueOf(1);
            }
            return this.writeLockCount;
        }
    }
}

