/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.locksandlatches;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Resource;
import hudson.model.ResourceActivity;
import hudson.model.ResourceList;
import hudson.plugins.locksandlatches.LockWrapper;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class LockWrapper
extends BuildWrapper
implements ResourceActivity {
    private List<LockWaitConfig> locks;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final Logger LOGGER = Logger.getLogger(LockWrapper.class.getName());

    public LockWrapper(List<LockWaitConfig> locks) {
        this.locks = locks;
    }

    public List<LockWaitConfig> getLocks() {
        return this.locks;
    }

    public void setLocks(List<LockWaitConfig> locks) {
        this.locks = locks;
    }

    public Descriptor<BuildWrapper> getDescriptor() {
        return DESCRIPTOR;
    }

    public ResourceList getResourceList() {
        ResourceList resources = new ResourceList();
        for (LockWaitConfig lock : this.locks) {
            resources.w(new Resource(null, "locks-and-latches/lock/" + lock.getName(), DESCRIPTOR.getWriteLockCount()));
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildWrapper.Environment setUp(AbstractBuild abstractBuild, Launcher launcher, BuildListener buildListener) throws IOException, InterruptedException {
        ArrayList<ReentrantLock> backups = new ArrayList<ReentrantLock>();
        ArrayList locks = new ArrayList(this.locks);
        Collections.sort(locks, new /* Unavailable Anonymous Inner Class!! */);
        for (LockWaitConfig lock : locks) {
            ReentrantLock backupLock;
            do {
                if ((backupLock = (ReentrantLock)DescriptorImpl.access$000((DescriptorImpl)DESCRIPTOR).get(lock.getName())) != null) continue;
                DescriptorImpl.access$000((DescriptorImpl)DESCRIPTOR).putIfAbsent(lock.getName(), new ReentrantLock());
            } while (backupLock == null);
            backups.add(backupLock);
        }
        buildListener.getLogger().println("[locks-and-latches] Checking to see if we really have the locks");
        boolean haveAll = false;
        while (!haveAll) {
            haveAll = true;
            ArrayList<ReentrantLock> locked = new ArrayList<ReentrantLock>();
            DescriptorImpl.access$100((DescriptorImpl)DESCRIPTOR).lock();
            try {
                for (ReentrantLock lock : backups) {
                    if (lock.tryLock()) {
                        locked.add(lock);
                        continue;
                    }
                    haveAll = false;
                    break;
                }
                if (!haveAll) {
                    for (ReentrantLock lock : locked) {
                        lock.unlock();
                    }
                }
            }
            finally {
                DescriptorImpl.access$100((DescriptorImpl)DESCRIPTOR).unlock();
            }
            if (haveAll) continue;
            buildListener.getLogger().println("[locks-and-latches] Could not get all the locks... sleeping for 1 minute");
            TimeUnit.SECONDS.sleep(60L);
        }
        buildListener.getLogger().println("[locks-and-latches] Have all the locks, build can start");
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public BuildWrapper.Environment setUp(Build build, Launcher launcher, BuildListener buildListener) throws IOException, InterruptedException {
        return this.setUp((AbstractBuild)build, launcher, buildListener);
    }

    public String getDisplayName() {
        return DESCRIPTOR.getDisplayName();
    }
}

