/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.locksandlatches;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatchWrapper
extends BuildWrapper {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final Logger LOGGER = Logger.getLogger(LatchWrapper.class.getName());

    public BuildWrapper.Environment setUp(AbstractBuild abstractBuild, Launcher launcher, BuildListener buildListener) throws IOException, InterruptedException {
        return new BuildWrapper.Environment(){};
    }

    public String getDisplayName() {
        return DESCRIPTOR.getDisplayName();
    }

    public Descriptor<BuildWrapper> getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class LatchWaitConfig
    implements Serializable {
        private String name;
        private transient LatchConfig latch;

        public LatchWaitConfig() {
        }

        @DataBoundConstructor
        public LatchWaitConfig(String name) {
            this.name = name;
        }

        public LatchConfig getLatch() {
            if (this.latch == null && this.name != null && !"".equals(this.name)) {
                this.setLatch(DESCRIPTOR.getLatch(this.name));
            }
            return this.latch;
        }

        public void setLatch(LatchConfig latch) {
            this.latch = latch;
        }

        public String getName() {
            if (this.latch == null) {
                return this.name;
            }
            this.name = this.latch.getName();
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.setLatch(DESCRIPTOR.getLatch(this.name));
        }
    }

    public static final class LatchConfig
    implements Serializable {
        private String name;
        private int count;
        private long timeout;

        public LatchConfig() {
            this.count = 1;
        }

        @DataBoundConstructor
        public LatchConfig(String name, int count, long timeout) {
            this.name = name;
            this.count = count;
            this.timeout = timeout;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LatchConfig that = (LatchConfig)o;
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<BuildWrapper> {
        private List<LatchConfig> latches;
        private static transient ConcurrentMap<LatchConfig, Set<AbstractBuild>> waitingJobs = new ConcurrentHashMap<LatchConfig, Set<AbstractBuild>>();
        private static transient ConcurrentMap<LatchConfig, Boolean> releasedLatches = new ConcurrentHashMap<LatchConfig, Boolean>();

        public void register(AbstractBuild build, Set<LatchConfig> latches) {
        }

        DescriptorImpl() {
            super(LatchWrapper.class);
            this.load();
        }

        public String getDisplayName() {
            return "Latches";
        }

        public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            List latches = req.bindParametersToList(LatchWaitConfig.class, "latches.latches.");
            return new LatchWrapper();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindParameters((Object)this, "latches.");
            this.latches = req.bindParametersToList(LatchConfig.class, "latches.latch.");
            this.save();
            return super.configure(req, formData);
        }

        public List<LatchConfig> getLatches() {
            if (this.latches == null) {
                this.latches = new ArrayList<LatchConfig>();
                this.latches.add(new LatchConfig("(default)", 1, 360L));
            }
            return this.latches;
        }

        public void setLatches(List<LatchConfig> latches) {
            this.latches = latches;
        }

        public LatchConfig getLatch(String name) {
            this.getLatches();
            for (LatchConfig latchConfig : this.latches) {
                if (!name.equals(latchConfig.getName())) continue;
                return latchConfig;
            }
            return null;
        }

        public String[] getLatchNames() {
            String[] result = new String[this.latches.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.latches.get(i).getName();
            }
            return result;
        }

        public void addLatch(LatchConfig latch) {
            this.latches.add(latch);
            this.save();
        }
    }
}

