/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.model.AbstractBuild;
import hudson.plugins.logparser.LogParserAction;
import hudson.plugins.logparser.LogParserDisplayConsts;
import hudson.plugins.logparser.LogParserResult;
import hudson.plugins.logparser.LogParserUtils;
import hudson.plugins.logparser.LogParserWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;

public class LogParserParser {
    private final HashMap statusCount = new HashMap();
    private final HashMap writers = new HashMap();
    private final HashMap linkFiles = new HashMap();
    private final String[] parsingRulesArray;
    private final Pattern[] compiledPatterns;
    private final HashMap statusCountPerSection = new HashMap();
    private final ArrayList headerForSection = new ArrayList();
    private int sectionCounter = 0;
    private final LogParserDisplayConsts displayConstants = new LogParserDisplayConsts();

    public LogParserParser(String parsingRulesPath) throws FileNotFoundException, IOException {
        this.statusCount.put("ERROR", 0);
        this.statusCount.put("WARNING", 0);
        this.statusCount.put("INFO", 0);
        this.parsingRulesArray = LogParserUtils.readParsingRules((String)parsingRulesPath);
        this.compiledPatterns = LogParserUtils.compilePatterns((String[])this.parsingRulesArray);
    }

    public LogParserResult parseLog(AbstractBuild build) throws FileNotFoundException, IOException {
        File logFile = build.getLogFile();
        String logDirectory = logFile.getParent();
        String filePath = logFile.getAbsolutePath();
        String parsedFilePath = logDirectory + "/log_content.html";
        String errorLinksFilePath = logDirectory + "/logerrorLinks.html";
        String warningLinksFilePath = logDirectory + "/logwarningLinks.html";
        String infoLinksFilePath = logDirectory + "/loginfoLinks.html";
        String buildRefPath = logDirectory + "/log_ref.html";
        String buildWrapperPath = logDirectory + "/log.html";
        this.linkFiles.put("ERROR", errorLinksFilePath);
        this.linkFiles.put("WARNING", warningLinksFilePath);
        this.linkFiles.put("INFO", infoLinksFilePath);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        BufferedWriter writer = new BufferedWriter(new FileWriter(parsedFilePath));
        this.writers.put("ERROR", new BufferedWriter(new FileWriter(errorLinksFilePath)));
        this.writers.put("WARNING", new BufferedWriter(new FileWriter(warningLinksFilePath)));
        this.writers.put("INFO", new BufferedWriter(new FileWriter(infoLinksFilePath)));
        String shortLink = " <a target=\"content\" href=\"log_content.html\">Beginning of log</a>";
        LogParserWriter.writeHeaderTemplateToAllLinkFiles((HashMap)this.writers, (int)this.sectionCounter);
        this.headerForSection.add(" <a target=\"content\" href=\"log_content.html\">Beginning of log</a>");
        writer.write("<html>\n\t<head>\n\t\t<link type=\"text/css\" rel=\"stylesheet\" href=\"/hudson/css/style.css\"></link>\n\t\t<link type=\"text/css\" rel=\"stylesheet\" href=\"/hudson/css/color.css\"></link>\n\t</head>\n\t<body>\n");
        String line = null;
        while ((line = reader.readLine()) != null) {
            String status = this.getLineStatus(line);
            String parsedLine = this.parseLine(line, status);
            writer.write(parsedLine);
            writer.newLine();
        }
        writer.write("\t</body>\n</html>\n");
        reader.close();
        writer.close();
        ((BufferedWriter)this.writers.get("ERROR")).close();
        ((BufferedWriter)this.writers.get("WARNING")).close();
        ((BufferedWriter)this.writers.get("INFO")).close();
        LogParserWriter.writeReferenceHtml((String)buildRefPath, (ArrayList)this.headerForSection, (HashMap)this.statusCountPerSection, (HashMap)this.displayConstants.getIconTable(), (HashMap)this.displayConstants.getLinkListDisplay(), (HashMap)this.displayConstants.getLinkListDisplayPlural(), (HashMap)this.statusCount, (HashMap)this.linkFiles);
        LogParserWriter.writeWrapperHtml((String)buildWrapperPath);
        String buildUrlPath = build.getUrl();
        String buildActionPath = LogParserAction.getUrlNameStat();
        String parsedLogURL = buildUrlPath + buildActionPath + "/log.html";
        LogParserResult result = new LogParserResult();
        result.setHtmlLogFile(parsedFilePath);
        result.setTotalErrors(((Integer)this.statusCount.get("ERROR")).intValue());
        result.setTotalWarnings(((Integer)this.statusCount.get("WARNING")).intValue());
        result.setTotalInfos(((Integer)this.statusCount.get("INFO")).intValue());
        result.setErrorLinksFile(errorLinksFilePath);
        result.setWarningLinksFile(warningLinksFilePath);
        result.setInfoLinksFile(infoLinksFilePath);
        result.setParsedLogURL(parsedLogURL);
        result.setHtmlLogPath(logDirectory);
        return result;
    }

    public String getLineStatus(String line) {
        for (int i = 0; i < this.parsingRulesArray.length; ++i) {
            String parsingRule = this.parsingRulesArray[i];
            if (LogParserUtils.skipParsingRule((String)parsingRule) || this.compiledPatterns[i] == null || !this.compiledPatterns[i].matcher(line).find()) continue;
            String status = parsingRule.split("\\s")[0];
            return LogParserUtils.standardizeStatus((String)status);
        }
        return "NONE";
    }

    public String parseLine(String line) throws IOException {
        return this.parseLine(line, null);
    }

    public String parseLine(String line, String status) throws IOException {
        String parsedLine = line;
        String effectiveStatus = status;
        if (status.equals("START")) {
            effectiveStatus = "INFO";
        }
        parsedLine = parsedLine.replaceAll("<", "&lt;");
        parsedLine = parsedLine.replaceAll(">", "&gt;");
        if (effectiveStatus != null && !effectiveStatus.equals("NONE")) {
            String parsedLineColoredAndMarked;
            this.incrementCounter(effectiveStatus);
            this.incrementCounterPerSection(status, this.sectionCounter);
            String parsedLineColored = this.colorLine(parsedLine, effectiveStatus);
            parsedLine = parsedLineColoredAndMarked = this.addMarkerAndLink(parsedLineColored, effectiveStatus, status);
        }
        StringBuffer result = new StringBuffer(parsedLine);
        result.append("<br/>\n");
        return result.toString();
    }

    public void incrementCounter(String status) {
        int currentVal = (Integer)this.statusCount.get(status);
        this.statusCount.put(status, currentVal + 1);
    }

    public void incrementCounterPerSection(String status, int sectionNumber) {
        String key = LogParserUtils.getSectionCountKey((String)status, (int)sectionNumber);
        Integer currentValInteger = (Integer)this.statusCountPerSection.get(key);
        if (currentValInteger == null) {
            currentValInteger = new Integer(0);
        }
        int newVal = currentValInteger + 1;
        this.statusCountPerSection.put(key, newVal);
    }

    private String colorLine(String line, String status) {
        String color = (String)this.displayConstants.getColorTable().get(status);
        StringBuffer result = new StringBuffer("<font color=\"");
        result.append(color);
        result.append("\">");
        result.append(line);
        result.append("</font>");
        return result.toString();
    }

    private String addMarkerAndLink(String line, String effectiveStatus, String status) throws IOException {
        String statusCountStr = ((Integer)this.statusCount.get(effectiveStatus)).toString();
        String marker = effectiveStatus + statusCountStr;
        StringBuffer shortLink = new StringBuffer(" <a target=\"content\" href=\"log_content.html#");
        shortLink.append(marker);
        shortLink.append("\">");
        shortLink.append(line);
        shortLink.append("</a>");
        StringBuffer link = new StringBuffer("<li>");
        link.append(statusCountStr);
        link.append(shortLink);
        link.append("</li><br/>");
        BufferedWriter linkWriter = (BufferedWriter)this.writers.get(effectiveStatus);
        linkWriter.write(link.toString());
        linkWriter.newLine();
        StringBuffer markedLine = new StringBuffer("<a name=\"");
        markedLine.append(marker);
        markedLine.append("\"></a>");
        markedLine.append(line);
        if (status.equals("START")) {
            ++this.sectionCounter;
            LogParserWriter.writeHeaderTemplateToAllLinkFiles((HashMap)this.writers, (int)this.sectionCounter);
            StringBuffer brShortLink = new StringBuffer("<br/>");
            brShortLink.append(shortLink);
            this.headerForSection.add(brShortLink.toString());
        }
        return markedLine.toString();
    }
}

