/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.plugins.logparser.LogParserConsts;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public final class LogParserUtils {
    public static String[] readParsingRules(String parsingRulesPath) throws FileNotFoundException, IOException {
        StringBuffer result = new StringBuffer("");
        BufferedReader reader = new BufferedReader(new FileReader(parsingRulesPath));
        String line = null;
        while ((line = reader.readLine()) != null) {
            result.append(line);
            result.append('\n');
        }
        reader.close();
        return result.toString().split("\n");
    }

    public static boolean skipParsingRule(String parsingRule) {
        boolean skip = false;
        if (parsingRule == null || parsingRule.equals("") || parsingRule.charAt(0) == '#' || parsingRule.startsWith("\\s") || parsingRule.startsWith("\r") || parsingRule.contains("$header")) {
            skip = true;
        }
        return skip;
    }

    public static String standardizeStatus(String status) {
        List<String> legals = LogParserConsts.LEGAL_STATUS;
        String result = status;
        result = result.equalsIgnoreCase("ok") ? "NONE" : (result.equalsIgnoreCase("end") ? "INFO" : (result.equalsIgnoreCase("warn") || result.equalsIgnoreCase("end") ? "WARNING" : result.toUpperCase(Locale.ENGLISH)));
        if (!legals.contains(result)) {
            result = "NONE";
        }
        return result;
    }

    public static Pattern[] compilePatterns(String[] parsingRulesArray) {
        Pattern[] result = new Pattern[parsingRulesArray.length];
        for (int i = 0; i < parsingRulesArray.length; ++i) {
            Pattern p;
            String parsingRule = parsingRulesArray[i];
            result[i] = null;
            if (LogParserUtils.skipParsingRule(parsingRule)) continue;
            String[] ruleParts = parsingRule.split("\\s");
            String regexp = ruleParts[1];
            int firstDash = parsingRule.indexOf(47);
            int lastDash = parsingRule.lastIndexOf(47);
            if (firstDash == -1 || firstDash == -1) continue;
            regexp = parsingRule.substring(firstDash + 1, lastDash);
            result[i] = p = Pattern.compile(regexp);
        }
        return result;
    }

    public static String getSectionCountKey(String status, int sectionNumber) {
        return Integer.toString(sectionNumber) + "-" + status;
    }

    private LogParserUtils() {
    }
}

