/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.PluginWrapper;
import hudson.model.Hudson;
import hudson.plugins.logparser.LogParserConsts;
import hudson.plugins.logparser.LogParserUtils;
import hudson.plugins.logparser.PluginImpl;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class LogParserWriter {
    public static void writeHeaderTemplateToAllLinkFiles(HashMap writers, int sectionCounter) throws IOException {
        List<String> statuses = LogParserConsts.STATUSES_WITH_SECTIONS_IN_LINK_FILES;
        int statusesSize = statuses.size();
        for (int i = 0; i < statusesSize; ++i) {
            String currentStatus = statuses.get(i);
            BufferedWriter linkWriter = (BufferedWriter)writers.get(currentStatus);
            String str = "HEADER HERE: #NUMBER";
            str = str.replaceFirst("NUMBER", Integer.valueOf(sectionCounter).toString());
            linkWriter.write(str + "\n");
        }
    }

    public static void writeWrapperHtml(String buildWrapperPath) throws IOException {
        String wrapperHtml = "<frameset cols=\"270,*\">\n<frame src=\"log_ref.html\" scrolling=auto name=\"sidebar\">\n<frame src=\"log_content.html\" scrolling=auto name=\"content\">\n<noframes>\n<p>Viewing the build report requires a Frames-enabled browser</p>\n<a href='build.log'>build log</a>\n</noframes>\n</frameset>\n";
        BufferedWriter writer = new BufferedWriter(new FileWriter(buildWrapperPath));
        writer.write("<frameset cols=\"270,*\">\n<frame src=\"log_ref.html\" scrolling=auto name=\"sidebar\">\n<frame src=\"log_content.html\" scrolling=auto name=\"content\">\n<noframes>\n<p>Viewing the build report requires a Frames-enabled browser</p>\n<a href='build.log'>build log</a>\n</noframes>\n</frameset>\n");
        writer.close();
    }

    public static void writeReferenceHtml(String buildRefPath, ArrayList headerForSection, HashMap statusCountPerSection, HashMap iconTable, HashMap linkListDisplay, HashMap linkListDisplayPlural, HashMap statusCount, HashMap linkFiles) throws IOException {
        String refStart = "<base target=\"content\">\n<script language=\"JavaScript\" type=\"text/javascript\">\n\tfunction toggleList(list){\n\t\telement = document.getElementById(list).style;\n\t\telement.display == 'none' ? element.display='block' : element.display='none';\n\t}\n</script>\n";
        BufferedWriter writer = new BufferedWriter(new FileWriter(buildRefPath));
        writer.write("<html>\n\t<head>\n\t\t<link type=\"text/css\" rel=\"stylesheet\" href=\"/hudson/css/style.css\"></link>\n\t\t<link type=\"text/css\" rel=\"stylesheet\" href=\"/hudson/css/color.css\"></link>\n\t</head>\n\t<body>\n");
        writer.write("<base target=\"content\">\n<script language=\"JavaScript\" type=\"text/javascript\">\n\tfunction toggleList(list){\n\t\telement = document.getElementById(list).style;\n\t\telement.display == 'none' ? element.display='block' : element.display='none';\n\t}\n</script>\n");
        LogParserWriter.writeLinks(writer, "ERROR", headerForSection, statusCountPerSection, iconTable, linkListDisplay, linkListDisplayPlural, statusCount, linkFiles);
        LogParserWriter.writeLinks(writer, "WARNING", headerForSection, statusCountPerSection, iconTable, linkListDisplay, linkListDisplayPlural, statusCount, linkFiles);
        LogParserWriter.writeLinks(writer, "INFO", headerForSection, statusCountPerSection, iconTable, linkListDisplay, linkListDisplayPlural, statusCount, linkFiles);
        writer.write("\t</body>\n</html>\n");
        writer.close();
    }

    private static void writeLinks(BufferedWriter writer, String status, ArrayList headerForSection, HashMap statusCountPerSection, HashMap iconTable, HashMap linkListDisplay, HashMap linkListDisplayPlural, HashMap statusCount, HashMap linkFiles) throws IOException {
        String statusIcon = (String)iconTable.get(status);
        String linkListDisplayStr = (String)linkListDisplay.get(status);
        String linkListDisplayStrPlural = (String)linkListDisplayPlural.get(status);
        String linkListCount = ((Integer)statusCount.get(status)).toString();
        String hudsonRoot = Hudson.getInstance().getRootUrl();
        PluginWrapper wrapper = Hudson.getInstance().getPluginManager().getPlugin(PluginImpl.class);
        String iconLocation = "/plugin/" + wrapper.getShortName() + "/images/";
        String linksStart = "<img src=\"" + hudsonRoot + "/" + iconLocation + statusIcon + "\" style=\"margin: 2px;\" width=\"24\" alt=\"\" height=\"24\"></img>\n" + "<a href=\"javascript:toggleList('" + linkListDisplayStr + "')\" target=\"_self\"><STRONG>" + linkListDisplayStr + " (" + linkListCount + ")</STRONG></a><br/>\n" + "<ul id=\"" + linkListDisplayStr + "\" type=\"disc\" style=\"display:none\">\n";
        writer.write(linksStart);
        BufferedReader reader = new BufferedReader(new FileReader((String)linkFiles.get(status)));
        String line = null;
        String summaryLine = "<br/>(SUMMARY_INT_HERE LINK_LIST_DISPLAY_STR in this section)<br/>";
        String headerTemplateRegexp = "HEADER HERE:";
        String headerTemplateSplitBy = "#";
        while ((line = reader.readLine()) != null) {
            String curSummaryLine = null;
            if (line.startsWith("HEADER HERE:")) {
                String headerNum = line.split("#")[1];
                line = (String)headerForSection.get(Integer.parseInt(headerNum));
                String key = LogParserUtils.getSectionCountKey(status, Integer.valueOf(headerNum));
                Integer summaryInt = (Integer)statusCountPerSection.get(key);
                if (summaryInt == null || summaryInt == 0) {
                    line = null;
                } else {
                    String linkListDisplayStrWithPlural = linkListDisplayStr;
                    if (summaryInt > 1) {
                        linkListDisplayStrWithPlural = linkListDisplayStrPlural;
                    }
                    curSummaryLine = "<br/>(SUMMARY_INT_HERE LINK_LIST_DISPLAY_STR in this section)<br/>".replace("SUMMARY_INT_HERE", summaryInt.toString()).replace("LINK_LIST_DISPLAY_STR", linkListDisplayStrWithPlural);
                }
            }
            if (line != null) {
                writer.write(line);
                writer.newLine();
            }
            if (curSummaryLine == null) continue;
            writer.write(curSummaryLine);
            writer.newLine();
        }
        reader.close();
        String linksEnd = "</ul>\n";
        writer.write("</ul>\n");
    }

    private LogParserWriter() {
    }
}

