/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.logparser.LogParserAction;
import hudson.plugins.logparser.LogParserParser;
import hudson.plugins.logparser.LogParserResult;
import hudson.plugins.logparser.ParserRuleFile;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogParserPublisher
extends Recorder
implements Serializable {
    public final boolean failBuildOnError;
    public final String parsingRulesPath;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public LogParserPublisher(boolean failBuildOnError, String parsingRulesPath) {
        this.failBuildOnError = failBuildOnError;
        this.parsingRulesPath = parsingRulesPath;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        LogParserResult result = new LogParserResult();
        try {
            File logParsingRulesFile = new File(this.parsingRulesPath);
            if (logParsingRulesFile.isFile()) {
                LogParserParser parser = new LogParserParser(this.parsingRulesPath, launcher.getChannel());
                result = parser.parseLog(build);
                if (this.failBuildOnError && result.getTotalErrors() > 0) {
                    build.setResult(Result.FAILURE);
                }
            } else {
                String errorMsg = "log-parser plugin ERROR: Cannot parse log: Can't read parsing rules file:" + this.parsingRulesPath;
                logger.log(Level.SEVERE, errorMsg);
                result.setFailedToParseError(errorMsg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMsg = e.getMessage();
            logger.log(Level.SEVERE, errorMsg);
            result.setFailedToParseError(errorMsg);
        }
        LogParserAction action = new LogParserAction(build, result);
        build.getActions().add(0, action);
        return true;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public ParserRuleFile[] getParserRuleChoices() {
        return ((DescriptorImpl)this.getDescriptor()).getParsingRulesGlobal();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
        private volatile ParserRuleFile[] parsingRulesGlobal = new ParserRuleFile[0];

        private DescriptorImpl() {
            super(LogParserPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return "Console output (build log) parsing";
        }

        public String getHelpFile() {
            return "/plugin/log-parser/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public ParserRuleFile[] getParsingRulesGlobal() {
            return this.parsingRulesGlobal;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.parsingRulesGlobal = req.bindParametersToList(ParserRuleFile.class, "log-parser.").toArray(new ParserRuleFile[0]);
            this.save();
            return true;
        }
    }

    private static final class AbortException
    extends RuntimeException {
        private AbortException() {
        }
    }
}

