/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.plugins.logparser.LogParserLogPart;
import hudson.plugins.logparser.LogParserReader;
import hudson.plugins.logparser.LogParserUtils;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

class LogParserThread
extends Thread {
    private LogParserLogPart logPart;
    private final String[] parsingRulesArray;
    private final Pattern[] compiledPatterns;
    private final int threadNum;
    private String[] logPartStatuses;
    private int numOfLines;
    private final LogParserReader logParserReader;

    public LogParserThread(LogParserReader logParserReader, String[] parsingRulesArray, Pattern[] compiledPatterns, int threadNum) {
        this.parsingRulesArray = parsingRulesArray;
        this.compiledPatterns = compiledPatterns;
        this.threadNum = threadNum;
        this.logParserReader = logParserReader;
    }

    public void run() {
        try {
            this.logPart = this.logParserReader.readLogPart(this.threadNum);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logPartStatuses = this.getLineStatuses(this.logPart.getLines());
    }

    public String[] getLineStatuses() {
        return this.logPartStatuses;
    }

    public LogParserLogPart getLogPart() {
        return this.logPart;
    }

    public int getNumOfLines() {
        return this.numOfLines;
    }

    private String[] getLineStatuses(String[] logPart) {
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.log(Level.INFO, "LogParserThread: Start parsing log part " + this.logPart.getLogPartNum());
        this.numOfLines = 0;
        int numOfChars = 0;
        String[] result = new String[logPart.length];
        for (int i = 0; i < logPart.length; ++i) {
            String status;
            String line = logPart[i];
            if (line == null) continue;
            ++this.numOfLines;
            numOfChars += line.length();
            result[i] = status = this.getLineStatus(line);
        }
        logger.log(Level.INFO, "LogParserThread: Done parsing log part " + this.logPart.getLogPartNum());
        return result;
    }

    private String getLineStatus(String line) {
        for (int i = 0; i < this.parsingRulesArray.length; ++i) {
            String parsingRule = this.parsingRulesArray[i];
            if (LogParserUtils.skipParsingRule(parsingRule) || this.compiledPatterns[i] == null || !this.compiledPatterns[i].matcher(line).find()) continue;
            String status = parsingRule.split("\\s")[0];
            return LogParserUtils.standardizeStatus(status);
        }
        return "NONE";
    }

    public int getThreadNum() {
        return this.threadNum;
    }
}

