/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.logparser.LogParserAction;
import hudson.plugins.logparser.LogParserParser;
import hudson.plugins.logparser.LogParserPublisher;
import hudson.plugins.logparser.LogParserResult;
import hudson.plugins.logparser.ParserRuleFile;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogParserPublisher
extends Recorder
implements Serializable {
    public final boolean unstableOnWarning;
    public final boolean failBuildOnError;
    public final String parsingRulesPath;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public LogParserPublisher(boolean unstableOnWarning, boolean failBuildOnError, String parsingRulesPath) {
        this.unstableOnWarning = unstableOnWarning;
        this.failBuildOnError = failBuildOnError;
        this.parsingRulesPath = parsingRulesPath;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        LogParserResult result = new LogParserResult();
        try {
            File logParsingRulesFile = new File(this.parsingRulesPath);
            if (logParsingRulesFile.isFile()) {
                LogParserParser parser = new LogParserParser(this.parsingRulesPath, launcher.getChannel());
                result = parser.parseLog(build);
                if (this.failBuildOnError && result.getTotalErrors() > 0) {
                    build.setResult(Result.FAILURE);
                } else if (this.unstableOnWarning && result.getTotalWarnings() > 0) {
                    build.setResult(Result.UNSTABLE);
                }
            } else {
                String errorMsg = "log-parser plugin ERROR: Cannot parse log: Can't read parsing rules file:" + this.parsingRulesPath;
                logger.log(Level.SEVERE, errorMsg);
                result.setFailedToParseError(errorMsg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMsg = e.getMessage();
            logger.log(Level.SEVERE, errorMsg);
            result.setFailedToParseError(errorMsg);
        }
        LogParserAction action = new LogParserAction(build, result);
        build.getActions().add(0, action);
        return true;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public ParserRuleFile[] getParserRuleChoices() {
        return ((DescriptorImpl)this.getDescriptor()).getParsingRulesGlobal();
    }
}

