/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;

public class LogParserResult {
    private int totalErrors = 0;
    private int totalWarnings = 0;
    private int totalInfos = 0;
    private String htmlLogFile;
    private String errorLinksFile;
    private String warningLinksFile;
    private String infoLinksFile;
    private String parsedLogURL;
    private String htmlLogPath;
    private String failedToParseError;
    private String badParsingRulesError;

    public String getBadParsingRulesError() {
        return this.badParsingRulesError;
    }

    public String getBadParsingRulesErrorDisplay() {
        return this.badParsingRulesError.replaceAll("\n", "<br/>");
    }

    public void setBadParsingRulesError(String badParsingRulesError) {
        this.badParsingRulesError = badParsingRulesError;
    }

    public String getFailedToParseError() {
        return this.failedToParseError;
    }

    public void setFailedToParseError(String failedToParseError) {
        this.failedToParseError = failedToParseError;
    }

    public int getTotalErrors() {
        return this.totalErrors;
    }

    public int getTotalWarnings() {
        return this.totalWarnings;
    }

    public int getTotalInfos() {
        return this.totalInfos;
    }

    public String getHtmlLogFile() {
        return this.htmlLogFile;
    }

    public String getHtmlLogPath() {
        return this.htmlLogPath;
    }

    public String getErrorLinksFile() {
        return this.errorLinksFile;
    }

    public String getWarningLinksFile() {
        return this.warningLinksFile;
    }

    public String getInfoLinksFile() {
        return this.infoLinksFile;
    }

    public String getParsedLogURL() {
        return this.parsedLogURL;
    }

    public Reader getReader(String filePath) throws IOException {
        File logFile = new File(filePath);
        if (logFile.exists()) {
            return new FileReader(logFile);
        }
        return null;
    }

    public Reader getLogReader() throws IOException {
        return this.getReader(this.getHtmlLogFile());
    }

    public Reader getErrorLinksReader() throws IOException {
        return this.getReader(this.getErrorLinksFile());
    }

    public Reader getWarningLinksReader() throws IOException {
        return this.getReader(this.getWarningLinksFile());
    }

    public Reader getInfoLinksReader() throws IOException {
        return this.getReader(this.getInfoLinksFile());
    }

    public void setHtmlLogFile(String file) {
        this.htmlLogFile = file;
    }

    public void setHtmlLogPath(String dir) {
        this.htmlLogPath = dir;
    }

    public void setErrorLinksFile(String file) {
        this.errorLinksFile = file;
    }

    public void setWarningLinksFile(String file) {
        this.warningLinksFile = file;
    }

    public void setInfoLinksFile(String file) {
        this.infoLinksFile = file;
    }

    public void setTotalErrors(int totalErrors) {
        this.totalErrors = totalErrors;
    }

    public void setTotalWarnings(int totalWarnings) {
        this.totalWarnings = totalWarnings;
    }

    public void setTotalInfos(int totalInfos) {
        this.totalInfos = totalInfos;
    }

    public void setParsedLogURL(String parsedLogURL) {
        this.parsedLogURL = parsedLogURL;
    }

    public File getHtmlLogFileToRead() {
        return new File(this.htmlLogFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHtmlContent() {
        StringBuffer result = new StringBuffer("");
        String line = "";
        try {
            File file = null;
            RandomAccessFile f = null;
            try {
                file = this.getHtmlLogFileToRead();
                f = new RandomAccessFile(file, "r");
                while ((line = f.readLine()) != null) {
                    result.append(line);
                    result.append("<br/>");
                }
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }
}

