/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.plugins.logparser.LogParserResult;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogParserAction
implements Action {
    private final AbstractBuild<?, ?> build;
    private final LogParserResult result;
    private static String urlName = "parsed_console";

    public LogParserAction(AbstractBuild<?, ?> build, LogParserResult result) {
        this.build = build;
        this.result = result;
    }

    public String getIconFileName() {
        return "clipboard.gif";
    }

    public String getDisplayName() {
        return "Parsed Console Output";
    }

    public String getUrlName() {
        return urlName;
    }

    public static String getUrlNameStat() {
        return urlName;
    }

    public AbstractBuild<?, ?> getOwner() {
        return this.build;
    }

    public LogParserResult getResult() {
        return this.result;
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        String dir = this.result.getHtmlLogPath();
        String file = req.getRestOfPath();
        String[] fileArray = file.split("/");
        String lastFileInPath = fileArray[fileArray.length - 1];
        File f = new File(dir + "/" + lastFileInPath);
        rsp.serveFile(req, f.toURI().toURL());
    }
}

