/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.FilePath;
import hudson.plugins.logparser.LogParserLogPart;
import hudson.plugins.logparser.LogParserReader;
import hudson.plugins.logparser.LogParserThread;
import hudson.plugins.logparser.LogParserUtils;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogParserStatusComputer
implements Serializable {
    private final String[] parsingRulesArray;
    private final Pattern[] compiledPatterns;
    private final HashMap<String, String> computedStatusMatches;

    public LogParserStatusComputer(VirtualChannel channel, FilePath filePath, String[] parsingRulesArray, Pattern[] compiledPatterns, int linesInLog, String signature) throws IOException, InterruptedException {
        this.parsingRulesArray = parsingRulesArray;
        this.compiledPatterns = compiledPatterns;
        this.computedStatusMatches = this.computeStatusMatches(filePath, linesInLog, channel, signature);
    }

    private HashMap<String, String> computeStatusMatches(final FilePath filePath, final int linesInLog, VirtualChannel channel, final String signature) throws IOException, InterruptedException {
        HashMap result = null;
        try {
            result = (HashMap)channel.call((Callable)new Callable<HashMap<String, String>, RuntimeException>(){

                public HashMap<String, String> call() {
                    HashMap result = null;
                    try {
                        result = LogParserStatusComputer.this.computeStatusMatches(filePath, linesInLog, signature);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return result;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result;
    }

    private HashMap<String, String> computeStatusMatches(FilePath filePath, int linesInLog, String signature) throws FileNotFoundException, IOException, InterruptedException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        String tempDir = System.getProperty("java.io.tmpdir");
        if (!tempDir.endsWith(File.separator)) {
            StringBuffer tempDirBuffer = new StringBuffer(tempDir);
            tempDirBuffer.append(File.separator);
            tempDir = tempDirBuffer.toString();
        }
        String tempFileLocation = tempDir + "log-parser_" + signature;
        File tempFile = new File(tempFileLocation);
        FilePath tempFilePath = new FilePath(tempFile);
        filePath.copyTo(tempFilePath);
        logger.log(Level.INFO, "Local temp file:" + tempFileLocation);
        BufferedReader reader = new BufferedReader(new InputStreamReader(tempFilePath.read()));
        int counter = 0;
        int threadCounter = 0;
        ArrayList<LogParserThread> runners = new ArrayList<LogParserThread>();
        LogParserReader logParserReader = new LogParserReader(reader);
        ExecutorService execSvc = Executors.newCachedThreadPool();
        int threadsNeeded = linesInLog / LogParserUtils.getLinesPerThread() + 1;
        for (int i = 0; i < threadsNeeded; ++i) {
            LogParserThread logParserThread = new LogParserThread(logParserReader, this.parsingRulesArray, this.compiledPatterns, threadCounter);
            runners.add(logParserThread);
            execSvc.execute(logParserThread);
            ++threadCounter;
        }
        execSvc.shutdown();
        execSvc.awaitTermination(3600L, TimeUnit.SECONDS);
        int runnersSize = runners.size();
        LogParserThread[] sortedRunners = new LogParserThread[runnersSize];
        for (LogParserThread logParserThread : runners) {
            LogParserLogPart logPart = logParserThread.getLogPart();
            if (logPart == null) continue;
            int logPartNum = logPart.getLogPartNum();
            sortedRunners[logPartNum] = logParserThread;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < runnersSize; ++i) {
            LogParserThread logParserThread = sortedRunners[i];
            if (logParserThread == null) continue;
            HashMap<String, String> moreLineStatusMatches = this.getLineStatusMatches(logParserThread.getLineStatuses(), i);
            result.putAll(moreLineStatusMatches);
            int newLines = logParserThread.getNumOfLines();
            counter += newLines;
        }
        reader.close();
        tempFilePath.delete();
        return result;
    }

    private HashMap<String, String> getLineStatusMatches(String[] statuses, int logPart) {
        HashMap<String, String> result = new HashMap<String, String>();
        int linesPerThread = LogParserUtils.getLinesPerThread();
        for (int i = 0; i < statuses.length; ++i) {
            String status = statuses[i];
            int line_num = i + logPart * linesPerThread;
            result.put(String.valueOf(line_num), status);
        }
        return result;
    }

    public HashMap<String, String> getComputedStatusMatches() {
        return this.computedStatusMatches;
    }
}

