/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.plugins.logparser.CompiledPatterns;
import hudson.plugins.logparser.LogParserConsts;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public final class LogParserUtils {
    public static String[] readParsingRules(String parsingRulesPath) throws FileNotFoundException, IOException {
        StringBuffer result = new StringBuffer("");
        BufferedReader reader = new BufferedReader(new FileReader(parsingRulesPath));
        String line = null;
        while ((line = reader.readLine()) != null) {
            result.append(line);
            result.append('\n');
        }
        reader.close();
        return result.toString().split("\n");
    }

    public static boolean skipParsingRule(String parsingRule) {
        boolean skip = false;
        if (parsingRule == null || parsingRule.equals("") || parsingRule.charAt(0) == '#' || parsingRule.startsWith("\\s") || parsingRule.startsWith("\r") || parsingRule.contains("$header")) {
            skip = true;
        }
        return skip;
    }

    public static String standardizeStatus(String status) {
        List<String> legals = LogParserConsts.LEGAL_STATUS;
        String result = status;
        result = result.equalsIgnoreCase("ok") ? "NONE" : (result.equalsIgnoreCase("end") ? "INFO" : (result.equalsIgnoreCase("warn") || result.equalsIgnoreCase("end") ? "WARNING" : result.toUpperCase(Locale.ENGLISH)));
        if (!legals.contains(result)) {
            result = "NONE";
        }
        return result;
    }

    public static CompiledPatterns compilePatterns(String[] parsingRulesArray, Logger logger) {
        Pattern[] result = new Pattern[parsingRulesArray.length];
        StringBuffer badParsingRules = new StringBuffer();
        for (int i = 0; i < parsingRulesArray.length; ++i) {
            String parsingRule = parsingRulesArray[i];
            result[i] = null;
            if (LogParserUtils.skipParsingRule(parsingRule)) continue;
            try {
                Pattern p;
                String[] ruleParts = parsingRule.split("\\s");
                String regexp = ruleParts[1];
                int firstDash = parsingRule.indexOf(47);
                int lastDash = parsingRule.lastIndexOf(47);
                if (firstDash == -1 || firstDash == -1) continue;
                regexp = parsingRule.substring(firstDash + 1, lastDash);
                result[i] = p = Pattern.compile(regexp);
                continue;
            }
            catch (Exception e) {
                String errorMsg = "Bad parsing rule:" + parsingRule + ", Error:" + e.getMessage();
                logger.log(Level.SEVERE, errorMsg);
                badParsingRules.append('\n');
                badParsingRules.append(errorMsg);
            }
        }
        CompiledPatterns fullResult = new CompiledPatterns();
        fullResult.setCompiledPatters(result);
        fullResult.setError(badParsingRules.toString());
        return fullResult;
    }

    public static String getSectionCountKey(String status, int sectionNumber) {
        return Integer.toString(sectionNumber) + "-" + status;
    }

    public static int getNumThreads() {
        int result = 2;
        String maxThreadsByEnvStr = System.getenv("HUDSON_LOG_PARSER_THREADS");
        if (maxThreadsByEnvStr != null) {
            try {
                result = Integer.valueOf(maxThreadsByEnvStr);
            }
            catch (Exception e) {
                Logger.getLogger("getNumThreads").log(Level.FINEST, "HUDSON_LOG_PARSER_THREADS is not an integer - using default");
            }
        }
        return result;
    }

    public static int getLinesPerThread() {
        int result = 10000;
        String linesByEnvStr = System.getenv("HUDSON_LOG_PARSER_LINES_PER_THREAD");
        if (linesByEnvStr != null) {
            try {
                result = Integer.valueOf(linesByEnvStr);
            }
            catch (Exception e) {
                Logger.getLogger("getLinesPerThread").log(Level.FINEST, "HUDSON_LOG_PARSER_LINES_PER_THREAD is not an integer - using default");
            }
        }
        return result;
    }

    public static int countLines(String filename) throws IOException {
        LineNumberReader reader = new LineNumberReader(new FileReader(filename));
        int count = 0;
        while (reader.readLine() != null) {
            ++count;
        }
        count = reader.getLineNumber();
        reader.close();
        return count;
    }

    private LogParserUtils() {
    }
}

