/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.m2extrasteps;

import hudson.Launcher;
import hudson.maven.AbstractMavenProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M2ExtraStepsWrapper
extends BuildWrapper {
    private List<Builder> preBuildSteps = new ArrayList<Builder>();
    private List<Builder> postBuildSteps = new ArrayList<Builder>();

    public List<Builder> getPreBuildSteps() {
        return this.preBuildSteps;
    }

    public void setPreBuildSteps(List<Builder> preBuildSteps) {
        this.preBuildSteps = preBuildSteps;
    }

    public List<Builder> getPostBuildSteps() {
        return this.postBuildSteps;
    }

    public void setPostBuildSteps(List<Builder> postSuccessBuildSteps) {
        this.postBuildSteps = postSuccessBuildSteps;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, final Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (!this.executeBuildSteps(this.preBuildSteps, build, launcher, listener)) {
            throw new IOException("Could not execute pre-build steps");
        }
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                build.keepLog();
                return M2ExtraStepsWrapper.this.executeBuildSteps(M2ExtraStepsWrapper.this.postBuildSteps, build, launcher, listener);
            }
        };
    }

    private boolean executeBuildSteps(List<Builder> buildSteps, AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean shouldContinue = true;
        for (Builder buildStep : buildSteps) {
            if (!shouldContinue) break;
            shouldContinue = buildStep.prebuild(build, listener);
        }
        for (Builder buildStep : buildSteps) {
            if (!shouldContinue) break;
            shouldContinue = buildStep.perform(build, launcher, listener);
        }
        return shouldContinue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return "Configure M2 Extra Build Steps";
        }

        public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            M2ExtraStepsWrapper instance = new M2ExtraStepsWrapper();
            instance.preBuildSteps = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"preBuildSteps", (Collection)Builder.all());
            instance.postBuildSteps = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"postBuildSteps", (Collection)Builder.all());
            return instance;
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return item instanceof AbstractMavenProject;
        }

        public String getHelpFile() {
            return "/plugin/m2-extra-steps/help-projectConfig.html";
        }
    }
}

