/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.m2extrasteps;

import hudson.Launcher;
import hudson.maven.AbstractMavenProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M2ExtraStepsWrapper
extends BuildWrapper {
    private List<Builder> preBuildSteps = new ArrayList<Builder>();
    private List<Builder> postBuildSteps = new ArrayList<Builder>();
    private String runIfResult;

    @DataBoundConstructor
    public M2ExtraStepsWrapper(String runIfResult) {
        this.runIfResult = runIfResult;
    }

    public List<Builder> getPreBuildSteps() {
        return this.preBuildSteps;
    }

    public void setPreBuildSteps(List<Builder> preBuildSteps) {
        this.preBuildSteps = preBuildSteps;
    }

    public List<Builder> getPostBuildSteps() {
        return this.postBuildSteps;
    }

    public void setPostBuildSteps(List<Builder> postBuildSteps) {
        this.postBuildSteps = postBuildSteps;
    }

    public String getRunIfResult() {
        return this.runIfResult;
    }

    public void setRunIfResult(String runIfResult) {
        this.runIfResult = runIfResult;
    }

    private boolean shouldPostStepsRun(AbstractBuild build) {
        if (this.runIfResult.equals("allCases")) {
            return true;
        }
        Result buildResult = build.getResult();
        if (this.runIfResult.equals("success")) {
            return buildResult == null || buildResult.isBetterOrEqualTo(Result.SUCCESS);
        }
        if (this.runIfResult.equals("unstable")) {
            return buildResult == null || buildResult.isBetterOrEqualTo(Result.UNSTABLE);
        }
        return false;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, final Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (!this.executeBuildSteps(this.preBuildSteps, build, launcher, listener)) {
            throw new IOException("Could not execute pre-build steps");
        }
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                if (M2ExtraStepsWrapper.this.shouldPostStepsRun(build)) {
                    return M2ExtraStepsWrapper.this.executeBuildSteps(M2ExtraStepsWrapper.this.postBuildSteps, build, launcher, listener);
                }
                return true;
            }
        };
    }

    private boolean executeBuildSteps(List<Builder> buildSteps, AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean shouldContinue = true;
        for (Builder buildStep : buildSteps) {
            if (!shouldContinue) break;
            shouldContinue = buildStep.prebuild(build, listener);
        }
        for (Builder buildStep : buildSteps) {
            if (!shouldContinue) break;
            shouldContinue = buildStep.perform(build, launcher, listener);
        }
        return shouldContinue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return "Configure M2 Extra Build Steps";
        }

        public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            M2ExtraStepsWrapper instance = (M2ExtraStepsWrapper)((Object)req.bindJSON(M2ExtraStepsWrapper.class, formData));
            instance.preBuildSteps = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"preBuildSteps", (Collection)Builder.all());
            instance.postBuildSteps = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"postBuildSteps", (Collection)Builder.all());
            return instance;
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return item instanceof AbstractMavenProject;
        }

        public String getHelpFile() {
            return "/plugin/m2-extra-steps/help-projectConfig.html";
        }
    }
}

