/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.m2extrasteps;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.m2extrasteps.M2ExtraStepsAction;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M2ExtraStepsWrapper
extends BuildWrapper {
    private List<Builder> preBuildSteps = new ArrayList();
    private List<Builder> postBuildSteps = new ArrayList();
    private String runIfResult;
    private static final Logger LOGGER = Logger.getLogger(M2ExtraStepsWrapper.class.getName());

    @DataBoundConstructor
    public M2ExtraStepsWrapper(String runIfResult) {
        this.runIfResult = runIfResult;
    }

    public List<Builder> getPreBuildSteps() {
        return this.preBuildSteps;
    }

    public void setPreBuildSteps(List<Builder> preBuildSteps) {
        this.preBuildSteps = preBuildSteps;
    }

    public List<Builder> getPostBuildSteps() {
        return this.postBuildSteps;
    }

    public void setPostBuildSteps(List<Builder> postBuildSteps) {
        this.postBuildSteps = postBuildSteps;
    }

    public String getRunIfResult() {
        return this.runIfResult;
    }

    public void setRunIfResult(String runIfResult) {
        this.runIfResult = runIfResult;
    }

    private boolean shouldPostStepsRun(AbstractBuild build) {
        if (this.runIfResult == null) {
            this.setRunIfResult("allCases");
        }
        if (this.runIfResult.equals("allCases")) {
            return true;
        }
        Result buildResult = build.getResult();
        if (this.runIfResult.equals("success")) {
            return buildResult == null || buildResult.isBetterOrEqualTo(Result.SUCCESS);
        }
        if (this.runIfResult.equals("unstable")) {
            return buildResult == null || buildResult.isBetterOrEqualTo(Result.UNSTABLE);
        }
        return false;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        build.addAction((Action)new M2ExtraStepsAction());
        if (!this.executeBuildSteps(this.preBuildSteps, build, launcher, listener)) {
            throw new IOException("Could not execute pre-build steps");
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private boolean executeBuildSteps(List<Builder> buildSteps, AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean shouldContinue = true;
        for (Builder buildStep : buildSteps) {
            if (!shouldContinue) break;
            shouldContinue = buildStep.prebuild(build, listener);
        }
        for (Builder buildStep : buildSteps) {
            if (!shouldContinue) break;
            shouldContinue = buildStep.perform(build, launcher, listener);
        }
        return shouldContinue;
    }

    static /* synthetic */ boolean access$000(M2ExtraStepsWrapper x0, AbstractBuild x1) {
        return x0.shouldPostStepsRun(x1);
    }

    static /* synthetic */ List access$100(M2ExtraStepsWrapper x0) {
        return x0.postBuildSteps;
    }

    static /* synthetic */ boolean access$200(M2ExtraStepsWrapper x0, List x1, AbstractBuild x2, Launcher x3, BuildListener x4) throws InterruptedException, IOException {
        return x0.executeBuildSteps(x1, x2, x3, x4);
    }

    static /* synthetic */ List access$302(M2ExtraStepsWrapper x0, List x1) {
        x0.preBuildSteps = x1;
        return x0.preBuildSteps;
    }

    static /* synthetic */ List access$102(M2ExtraStepsWrapper x0, List x1) {
        x0.postBuildSteps = x1;
        return x0.postBuildSteps;
    }
}

