/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.m2_repo_reaper;

import hudson.FilePath;
import hudson.Launcher;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.tasks.BuildWrapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M2RepoReaperWrapper
extends BuildWrapper {
    private String artifactPatterns;
    private List<String> patterns = new ArrayList();

    @DataBoundConstructor
    public M2RepoReaperWrapper(String artifactPatterns) {
        this.artifactPatterns = artifactPatterns;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(List<String> patterns) {
        this.patterns = patterns;
    }

    public String getArtifactPatterns() {
        return this.artifactPatterns;
    }

    public void setArtifactPatterns(String artifactPatterns) {
        this.artifactPatterns = artifactPatterns;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        MavenModuleSet moduleSet;
        try {
            moduleSet = (MavenModuleSet)build.getProject();
        }
        catch (ClassCastException e) {
            return null;
        }
        if (!moduleSet.usesPrivateRepository()) {
            return null;
        }
        String repoPath = build.getWorkspace().child(".repository").getRemote();
        if (!this.doReap(repoPath, this.patterns, listener)) {
            throw new IOException("Could not execute pre-build steps");
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private boolean doReap(String repoPath, List<String> patterns, BuildListener listener) throws InterruptedException, IOException {
        File repo = new File(repoPath);
        if (!repo.exists()) {
            return true;
        }
        FilePath filePath = new FilePath(repo);
        HashSet<FilePath> totalList = new HashSet<FilePath>();
        for (String pattern : patterns) {
            FilePath[] paths;
            for (FilePath fp : paths = filePath.list(pattern)) {
                totalList.add(fp);
            }
        }
        for (FilePath path : totalList) {
            listener.getLogger().append("Deleting " + path.absolutize() + "\n");
            try {
                path.deleteRecursive();
            }
            catch (IOException e) {
                listener.error("Failed to delete " + path.absolutize() + "\n");
            }
        }
        return true;
    }
}

