/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.m2release;

import hudson.Launcher;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import org.jvnet.hudson.plugins.m2release.M2ReleaseAction;
import org.jvnet.hudson.plugins.m2release.M2ReleaseBuildWrapper;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M2ReleaseBuildWrapper
extends BuildWrapper {
    private transient boolean doRelease = false;
    public static final String DEFAULT_RELEASE_GOALS = "release:prepare release:perform";
    public String releaseGoals = "release:prepare release:perform";
    public static final DescriptorImpl INSTANCE = new DescriptorImpl();

    @DataBoundConstructor
    public M2ReleaseBuildWrapper(String releaseGoals) {
        this.releaseGoals = releaseGoals;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        String originalGoals;
        if (!this.doRelease) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        this.doRelease = false;
        if (build instanceof MavenBuild) {
            MavenBuild m2Build = (MavenBuild)build;
            MavenModule mm = (MavenModule)m2Build.getProject();
            MavenModuleSet mmSet = mm.getParent();
            originalGoals = mmSet.getGoals();
            mmSet.setGoals(this.releaseGoals);
        } else if (build instanceof MavenModuleSetBuild) {
            MavenModuleSetBuild m2moduleSetBuild = (MavenModuleSetBuild)build;
            MavenModuleSet mmSet = (MavenModuleSet)m2moduleSetBuild.getProject();
            originalGoals = mmSet.getGoals();
            mmSet.setGoals(this.releaseGoals);
        } else {
            originalGoals = null;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    void enableRelease() {
        this.doRelease = true;
    }

    public Action getProjectAction(AbstractProject job) {
        return new M2ReleaseAction((MavenModuleSet)job);
    }

    public Descriptor<BuildWrapper> getDescriptor() {
        return INSTANCE;
    }
}

