/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.m2release;

import hudson.Launcher;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.util.Map;
import org.jvnet.hudson.plugins.m2release.M2ReleaseAction;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M2ReleaseBuildWrapper
extends BuildWrapper {
    private transient boolean doRelease = false;
    private transient Map<String, String> versions;
    private transient boolean appendHudsonBuildNumber;
    public String releaseGoals = "-Dresume=false release:prepare release:perform";

    @DataBoundConstructor
    public M2ReleaseBuildWrapper(String releaseGoals) {
        this.releaseGoals = releaseGoals;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        String originalGoals;
        if (!this.doRelease) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        this.doRelease = false;
        if (build instanceof MavenBuild) {
            MavenBuild m2Build = (MavenBuild)build;
            MavenModule mm = (MavenModule)m2Build.getProject();
            MavenModuleSet mmSet = mm.getParent();
            originalGoals = mmSet.getGoals();
            mmSet.setGoals(this.releaseGoals);
            if (this.versions != null) {
                mmSet.setGoals(this.generateVersionString(build.getNumber()) + this.releaseGoals);
            } else {
                mmSet.setGoals(this.releaseGoals);
            }
        } else if (build instanceof MavenModuleSetBuild) {
            MavenModuleSetBuild m2moduleSetBuild = (MavenModuleSetBuild)build;
            MavenModuleSet mmSet = (MavenModuleSet)m2moduleSetBuild.getProject();
            originalGoals = mmSet.getGoals();
            if (this.versions != null) {
                mmSet.setGoals(this.generateVersionString(build.getNumber()) + this.releaseGoals);
            } else {
                mmSet.setGoals(this.releaseGoals);
            }
        } else {
            originalGoals = null;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    void enableRelease() {
        this.doRelease = true;
    }

    void setVersions(Map<String, String> versions) {
        this.versions = versions;
    }

    public void setAppendHudsonBuildNumber(boolean appendHudsonBuildNumber) {
        this.appendHudsonBuildNumber = appendHudsonBuildNumber;
    }

    private String generateVersionString(int buildNumber) {
        StringBuilder sb = new StringBuilder();
        for (String key : this.versions.keySet()) {
            sb.append(key);
            sb.append('=');
            sb.append((String)this.versions.get(key));
            if (this.appendHudsonBuildNumber && key.startsWith("-Dproject.rel")) {
                sb.append('-');
                sb.append(buildNumber);
            }
            sb.append(' ');
        }
        return sb.toString();
    }

    public Action getProjectAction(AbstractProject job) {
        return new M2ReleaseAction((MavenModuleSet)job);
    }

    public static boolean hasReleasePermission(AbstractProject job) {
        return job.hasPermission(Item.BUILD);
    }

    public static void checkReleasePermission(AbstractProject job) {
        job.checkPermission(Item.BUILD);
    }

    static /* synthetic */ Map access$002(M2ReleaseBuildWrapper x0, Map x1) {
        x0.versions = x1;
        return x0.versions;
    }
}

