/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.m2release;

import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.jvnet.hudson.plugins.m2release.M2ReleaseBuildWrapper;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M2ReleaseAction
implements Action {
    private MavenModuleSet project;

    public M2ReleaseAction(MavenModuleSet project) {
        this.project = project;
    }

    public String getDisplayName() {
        return "Perform Maven Release";
    }

    public String getIconFileName() {
        if (M2ReleaseBuildWrapper.hasReleasePermission((AbstractProject)this.project)) {
            return "installer.gif";
        }
        return null;
    }

    public String getUrlName() {
        return "m2release";
    }

    public Collection<MavenModule> getModules() {
        return this.project.getModules();
    }

    public String computeReleaseVersion(String version) {
        return version.replace("-SNAPSHOT", "");
    }

    public String computeNextVersion(String version) {
        String retVal = this.computeReleaseVersion(version);
        int dotIdx = retVal.lastIndexOf(46);
        if (dotIdx != -1) {
            String ver = retVal.substring(++dotIdx);
            int intVer = Integer.parseInt(ver);
            retVal = retVal.substring(0, dotIdx);
            retVal = retVal + ++intVer;
        } else {
            int intVer = Integer.parseInt(retVal);
            retVal = retVal.substring(0, dotIdx);
            retVal = Integer.toString(++intVer);
        }
        return retVal + "-SNAPSHOT";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSubmit(StaplerRequest req, StaplerResponse resp) throws IOException, ServletException {
        M2ReleaseBuildWrapper.checkReleasePermission((AbstractProject)this.project);
        M2ReleaseBuildWrapper m2Wrapper = (M2ReleaseBuildWrapper)this.project.getBuildWrappers().get(M2ReleaseBuildWrapper.class);
        Map httpParams = req.getParameterMap();
        HashMap<String, String> versions = null;
        boolean appendHudsonBuildNumber = httpParams.containsKey("appendHudsonBuildNumber");
        if (httpParams.containsKey("specifyVersions")) {
            versions = new HashMap<String, String>();
            for (Object key : httpParams.keySet()) {
                String keyStr = (String)key;
                if (!keyStr.startsWith("-Dproject.")) continue;
                versions.put(keyStr, (String)((Object[])httpParams.get(key))[0]);
            }
        }
        M2ReleaseBuildWrapper m2ReleaseBuildWrapper = m2Wrapper;
        synchronized (m2ReleaseBuildWrapper) {
            if (this.project.scheduleBuild(0, (Cause)new Cause.UserCause())) {
                m2Wrapper.enableRelease();
                m2Wrapper.setVersions(versions);
                m2Wrapper.setAppendHudsonBuildNumber(appendHudsonBuildNumber);
            }
        }
        resp.sendRedirect(this.project.getAbsoluteUrl());
    }
}

